
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Products')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Edit Product')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Edit Product')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Products')); ?></a>
            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.product.update',$product->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Thumbnail Image Preview')); ?></label>
                                    <div>
                                        <img id="preview-img" class="admin-img" src="<?php echo e(asset($product->thumb_image)); ?>" alt="">
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Thumnail Image')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control-file"  name="thumb_image" onchange="previewThumnailImage(event)">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="name" class="form-control"  name="name" value="<?php echo e($product->name); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Slug')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="slug" class="form-control"  name="slug" value="<?php echo e($product->slug); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Category')); ?> <span class="text-danger">*</span></label>
                                    <select name="category" class="form-control select2" id="category">
                                        <option value=""><?php echo e(__('admin.Select Category')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->category_id == $category->id ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Price')); ?> <span class="text-danger">*</span></label>
                                   <input type="text" class="form-control" name="price" value="<?php echo e($product->price); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Offer Price')); ?> </label>
                                   <input type="text" class="form-control" name="offer_price" value="<?php echo e($product->offer_price); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Short Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="short_description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($product->short_description); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Long Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="long_description" id="" cols="30" rows="10" class="summernote"><?php echo e($product->long_description); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Today Special')); ?> <span class="text-danger">*</span></label>
                                    <select name="today_special" class="form-control">
                                        <option <?php echo e($product->today_special == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Yes')); ?></option>
                                        <option <?php echo e($product->today_special == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.No')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option <?php echo e($product->status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option <?php echo e($product->status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Title')); ?></label>
                                   <input type="text" class="form-control" name="seo_title" value="<?php echo e($product->seo_title); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Description')); ?></label>
                                    <textarea name="seo_description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e($product->seo_description); ?></textarea>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>


<script>
    (function($) {
        "use strict";
        var specification = '<?php echo e($product->is_specification == 1 ? true : false); ?>';
        $(document).ready(function () {
            $("#name").on("focusout",function(e){
                $("#slug").val(convertToSlug($(this).val()));
            })
        });
    })(jQuery);

    function convertToSlug(Text){
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g,'')
                .replace(/ +/g,'-');
    }

    function previewThumnailImage(event) {
        var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('preview-img');
            output.src = reader.result;
        }
        reader.readAsDataURL(event.target.files[0]);
    };

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\unifood\script_content\main_files\resources\views/admin/edit_product.blade.php ENDPATH**/ ?>