
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <p>Configure Your Website</p>
            <div>
                <a class="btn btn-outline-primary" href="<?php echo e(route('setup.account')); ?>">&laquo; Back</a>
                <a class="btn btn-outline-primary <?php if(!session()->has('step-5-complete')): ?> disabled <?php endif; ?>" href="<?php echo e(route('setup.smtp')); ?>">Next &raquo;</a>
            </div>
        </div>
        <div class="card-body">
            <form id="config_form" autocomplete="off">
                <div class="mb-3">
                    <label>App Name <span class="text-danger">*</span></label>
                    <input type="text" id="config_app_name" name="config_app_name" class="form-control"
                        value="<?php echo e(old('config_app_name',$app_name ?? null)); ?>" placeholder="Enter Your App Name">
                </div>
                <button type="submit" id="submit_btn" class="btn btn-primary">Save Config</button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $(document).on('submit', '#config_form', async function(e) {
                e.preventDefault();
                let config_app_name = $('#config_app_name').val();
                let submit_btn = $('#submit_btn');

                if ($.trim(config_app_name) === '') {
                    toastr.warning("App Name is required");
                } else {
                    submit_btn.html(
                        'Saving... <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>'
                    ).prop('disabled', true);
                    try {
                        const res = await makeAjaxRequest({
                                config_app_name: config_app_name
                            },
                            "<?php echo e(route('setup.configuration.submit')); ?>");
                        if (res.success) {
                            toastr.success(res.message);
                            submit_btn.addClass('btn-success').html('Redirecting...');
                            window.location.href = "<?php echo e(route('setup.smtp')); ?>";
                        } else {
                            submit_btn.html('Save Config').prop('disabled', false);
                            toastr.error(res.message);
                        }
                    } catch (error) {
                        submit_btn.html('Save Config').prop('disabled', false);
                        $.each(error.errors, function(index, value) {
                            toastr.error(value);
                        });
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('setup.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\unifood\script_content\main_files\installer\views/setup/config.blade.php ENDPATH**/ ?>