
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Products')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Products')); ?></h1>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product.create')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('admin.Add New')); ?></a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th ><?php echo e(__('admin.SN')); ?></th>
                                    <th ><?php echo e(__('admin.Name')); ?></th>
                                    <th ><?php echo e(__('admin.Price')); ?></th>
                                    <th ><?php echo e(__('admin.Today Special')); ?></th>
                                    <th><?php echo e(__('admin.Translations')); ?></th>
                                    <th ><?php echo e(__('admin.Action')); ?></th>
                                  </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><a target="_blank" href="#"><?php echo e($product->name); ?></a></td>
                                        <td><?php echo e($setting->currency_icon); ?><?php echo e($product->price); ?></td>
                                        <td>
                                          <?php if($product->today_special): ?>
                                              <span class="badge badge-success"><?php echo e(__('admin.Yes')); ?></span>
                                          <?php else: ?>
                                          <span class="badge badge-danger"><?php echo e(__('admin.No')); ?></span>
                                          <?php endif; ?>
                                        </td>
                                        <td>
                                          <?php $__empty_1 = true; $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <a href="<?php echo e(route('admin.translation.product.create', [
                                            'code' => $language->code,
                                            'id' => $product->id
                                          ])); ?>"><i class="fa <?php echo e($product?->translation($language->code)?->first()?->name ? 'fa-check' : 'fa-edit'); ?>"></i> <?php echo e(strtoupper($language->code)); ?></a>
                                            <?php if(!$loop->last): ?>
                                              | 
                                            <?php endif; ?>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                          <a href="<?php echo e(route('admin.translation.product.create', [
                                            'code' => app()->getLocale(),
                                            'id' => $product->id
                                          ])); ?>"><i class="fa <?php echo e($product?->translation(app()->getLocale())?->first()?->name ? 'fa-check' : 'fa-edit'); ?>"></i> <?php echo e(strtoupper(app()->getLocale())); ?></a>
                                          <?php endif; ?>
                                        </td>

                                        <td>
                                        <a href="<?php echo e(route('admin.product.edit',$product->id)); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>

                                        <?php
                                            $existOrder = $orderProducts->where('product_id',$product->id)->count();
                                        ?>

                                        <?php if($existOrder == 0): ?>
                                            <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($product->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php else: ?>
                                            <a href="javascript:;" data-toggle="modal" data-target="#canNotDeleteModal" class="btn btn-danger btn-sm" disabled><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        <?php endif; ?>


                                        <div class="dropdown d-inline">
                                            <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                              <i class="fas fa-cog"></i>
                                            </button>

                                            <div class="dropdown-menu" x-placement="top-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, -131px, 0px);">
                                              <a class="dropdown-item has-icon" href="<?php echo e(route('admin.product-gallery',$product->id)); ?>"><i class="far fa-image"></i> <?php echo e(__('admin.Image Gallery')); ?></a>

                                              <a class="dropdown-item has-icon" href="<?php echo e(route('admin.product-variant',$product->id)); ?>"><i class="fas fa-cog"></i><?php echo e(__('admin.Size / Optional Item')); ?></a>

                                            </div>
                                          </div>

                                        </td>
                                    </tr>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

      <!-- Modal -->
      <div class="modal fade" id="canNotDeleteModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
          <div class="modal-dialog" role="document">
              <div class="modal-content">
                        <div class="modal-body">
                            <?php echo e(__('admin.You can not delete this product. Because there are one or more order has been created in this product.')); ?>

                        </div>

                  <div class="modal-footer">
                      <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                  </div>
              </div>
          </div>
      </div>
<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/product/")); ?>'+"/"+id)
    }
    function changeProductStatus(id){
        var isDemo = "<?php echo e(env('APP_MODE')); ?>"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '<?php echo e(csrf_token()); ?>' },
            url:"<?php echo e(url('/admin/product-status/')); ?>"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){
            }
        })
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\unifood\script_content\main_files\resources\views/admin/product.blade.php ENDPATH**/ ?>