<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, target-densityDpi=device-dpi" />

    <?php echo $__env->yieldContent('title'); ?>
    <?php echo $__env->yieldContent('meta'); ?>

    <link rel="icon" type="image/png" href="<?php echo e(asset($setting->favicon)); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/spacing.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/nice-select.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/venobox.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/jquery.exzoom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('toastr/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('user/css/responsive.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap-datepicker.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/select2.min.css')); ?>">


    <?php echo $__env->make('theme_color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(session()->get('text_direction') == 'rtl'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('user/css/rtl.css')); ?>">
    <?php endif; ?>

    <!--jquery library js-->
    <script src="<?php echo e(asset('user/js/jquery-3.6.3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/js/sweetalert2@11.js')); ?>"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>


    <?php if($googleAnalytic->status == 1): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($googleAnalytic->analytic_id); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '<?php echo e($googleAnalytic->analytic_id); ?>');
    </script>
    <?php endif; ?>

    <?php if($facebookPixel->status == 1): ?>
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '<?php echo e($facebookPixel->app_id); ?>');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=<?php echo e($facebookPixel->app_id); ?>&ev=PageView&noscript=1"
    /></noscript>
    <?php endif; ?>


</head>

<body>

    <div class="" id="preloader">
        <div class="img d-none">
            <img src="<?php echo e(asset('uploads/website-images/Spinner.gif')); ?>" alt="UniFood" class="img-fluid">
        </div>
    </div>

    <!--=============================
        TOPBAR START
    ==============================-->
    <section class="wsus__topbar">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-md-6 d-none d-md-block">
                    <ul class="wsus__topbar_info d-flex flex-wrap">
                        <li><a href="mailto:<?php echo e($footer->email); ?>"><i class="fas fa-envelope"></i> <?php echo e($footer->email); ?></a>
                        </li>
                        <li><a href="callto:<?php echo e($footer->phone); ?>"><i class="fas fa-phone-alt"></i> <?php echo e($footer->phone); ?></a></li>
                    </ul>
                </div>
                <div class="col-xl-6 col-md-6">
                    <div class="topbar_right">
                        <div class="topbar_language">
                            <form id="setLanguage" action="<?php echo e(route('set-language')); ?>">
                                <select id="select_js3" name="code">
                                    <?php $__empty_1 = true; $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option value="<?php echo e($language->code); ?>"<?php echo e(session()->get('lang') == $language->code ? 'selected' : ''); ?>><?php echo e($language->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <option value="en">English</option>
                                    <?php endif; ?>
                                </select>
                            </form>
                        </div>
                        <ul class="topbar_icon d-flex flex-wrap">
                            <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social_link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e($social_link->link); ?>"><i class="<?php echo e($social_link->icon); ?>"></i></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>   
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        TOPBAR END
    ==============================-->


    <!--=============================
        MENU START
    ==============================-->
    <nav class="navbar navbar-expand-lg main_menu">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(asset($setting->logo)); ?>" alt="UniFood" class="img-fluid">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <i class="far fa-bars"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav m-auto">

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('about-us')); ?>"><?php echo e(__('user.About Us')); ?></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('products')); ?>"><?php echo e(__('user.Products')); ?></a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="#"><?php echo e(__('user.pages')); ?> <i class="far fa-plus"></i></a>
                        <ul class="droap_menu">

                            <li>
                                <a href="<?php echo e(route('our-chef')); ?>"><?php echo e(__('user.Our chef')); ?></a>
                            </li>

                            <li><a href="<?php echo e(route('testimonial')); ?>"><?php echo e(__('user.Testimonial')); ?></a></li>

                            <li><a href="<?php echo e(route('faq')); ?>"><?php echo e(__('user.FAQs')); ?></a></li>

                            <li><a href="<?php echo e(route('privacy-policy')); ?>"><?php echo e(__('user.privacy policy')); ?></a></li>
                            <li><a href="<?php echo e(route('terms-and-condition')); ?>"><?php echo e(__('user.terms and condition')); ?></a></li>

                            <?php $__currentLoopData = $custom_pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom_page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('show-page', $custom_page->slug)); ?>"><?php echo e($custom_page->page_name_translated); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('blogs')); ?>"><?php echo e(__('user.Blogs')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('user.contact us')); ?></a>
                    </li>
                </ul>
                <ul class="menu_icon d-flex flex-wrap">
                    <li>
                        <a href="javascript:;" class="menu_search"><i class="far fa-search"></i></a>
                        <div class="wsus__search_form">
                            <form action="<?php echo e(route('products')); ?>">
                                <span class="close_search"><i class="far fa-times"></i></span>
                                <input name="search" type="text" placeholder="<?php echo e(__('user.Type your keyword')); ?>">
                                <button type="submit"><?php echo e(__('user.search')); ?></button>
                            </form>
                        </div>
                    </li>
                    <?php
                        $mini_cart_contents = Cart::content();
                    ?>
                    <li>
                        <a class="cart_icon"><i class="fas fa-shopping-basket"></i> <span class="topbar_cart_qty"><?php echo e(count($mini_cart_contents)); ?></span></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('dashboard')); ?>"><i class="fas fa-user"></i></a>
                    </li>
                    <li>
                        <?php if(auth()->guard('web')->check()): ?>
                        <a class="common_btn" href="#" data-bs-toggle="modal"
                        data-bs-target="#staticBackdrop"><?php echo e(__('user.reservation')); ?></a>
                        <?php else: ?>
                        <a class="common_btn" href="<?php echo e(route('login')); ?>"><?php echo e(__('user.reservation')); ?></a>
                        <?php endif; ?>

                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="wsus__menu_cart_area">
        <div class="wsus__menu_cart_boody">

            <?php if(count($mini_cart_contents) == 0): ?>
                <div class="wsus__menu_cart_header">
                    <h5><?php echo e(__('user.Your cart is empty')); ?></h5>
                    <span class="close_cart"><i class="fal fa-times"></i></span>
                </div>
            <?php else: ?>
                <div>
                    <div class="wsus__menu_cart_header">
                        <h5 class="mini_cart_body_item"><?php echo e(__('user.Total Item')); ?>(<?php echo e(count($mini_cart_contents)); ?>)</h5>
                        <span class="close_cart"><i class="fal fa-times"></i></span>
                    </div>
                    <ul class="mini_cart_list">
                        <?php
                            $mini_sub_total = 0;
                        ?>
                        <?php $__currentLoopData = $mini_cart_contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mini_cart_content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="min-item-<?php echo e($mini_cart_content->rowId); ?>" data-mini-item-rowid="<?php echo e($mini_cart_content->rowId); ?>">
                                <div class="menu_cart_img">
                                    <img src="<?php echo e(asset($mini_cart_content->options->image)); ?>" alt="menu" class="img-fluid w-100">
                                </div>
                                <div class="menu_cart_text">
                                    <a class="title" href="<?php echo e(route('show-product', $mini_cart_content->options->slug)); ?>"><?php echo e($mini_cart_content->name); ?> </a>
                                    <p class="size"><?php echo e($mini_cart_content->options->size); ?></p>
                                    <?php $__currentLoopData = $mini_cart_content->options->optional_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optional_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="extra"><?php echo e($optional_item['optional_name']); ?> (+<?php echo e($currency_icon); ?><?php echo e($optional_item['optional_price']); ?>)</span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php
                                        $item_price = $mini_cart_content->price * $mini_cart_content->qty;
                                        $item_total = $item_price + $mini_cart_content->options->optional_item_price;
                                        $mini_sub_total += $item_total;
                                    ?>

                                    <p class="price mini-price-<?php echo e($mini_cart_content->rowId); ?>"><?php echo e($currency_icon); ?><?php echo e($item_total); ?></p>
                                </div>
                                <input type="hidden" class="mini-input-price set-mini-input-price-<?php echo e($mini_cart_content->rowId); ?>" value="<?php echo e($item_total); ?>">
                                <span class="del_icon mini-item-remove"><i class="fal fa-times"></i></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                    <p class="subtotal"><?php echo e(__('user.Sub Total')); ?> <span class="mini_sub_total"><?php echo e($currency_icon); ?><?php echo e($mini_sub_total); ?></span></p>
                    <a class="cart_view" href="<?php echo e(route('cart')); ?>"> <?php echo e(__('user.view cart')); ?></a>
                    <a class="checkout" href="<?php echo e(route('checkout')); ?>"><?php echo e(__('user.checkout')); ?></a>
                </div>
            <?php endif; ?>

        </div>
    </div>

    <?php if(auth()->guard('web')->check()): ?>
        <div class="wsus__reservation">
            <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
                aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel"><?php echo e(__('user.Book a Table')); ?></h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form class="wsus__reservation_form" method="POST" action="<?php echo e(route('store-reservation')); ?>">
                                <?php echo csrf_field(); ?>
                                <?php
                                    $auth_user = Auth::guard('web')->user();
                                ?>
                                <?php if($auth_user->phone == null): ?>
                                <input class="reservation_input" type="text" placeholder="<?php echo e(__('user.Phone')); ?>" name="phone" required>
                                <?php endif; ?>
                                <input class="reservation_input datepicker" type="text" autocomplete="off" name="reserve_date" required placeholder="<?php echo e(__('user.Select date')); ?>">

                                <select class="reservation_input" id="select_js" required name="reserve_time">
                                    <option value=""><?php echo e(__('user.Select Time')); ?></option>
                                    <option value="12:00 AM - 01:00 AM">12:00 AM - 01:00 AM</option>
                                    <option value="01:00 AM - 02:00 AM">01:00 AM - 02:00 AM</option>
                                    <option value="02:00 AM - 03:00 AM">02:00 AM - 03:00 AM</option>
                                    <option value="03:00 AM - 04:00 AM">03:00 AM - 04:00 AM</option>
                                    <option value="04:00 AM - 05:00 AM">04:00 AM - 05:00 AM</option>
                                    <option value="05:00 AM - 06:00 AM">05:00 AM - 06:00 AM</option>
                                    <option value="06:00 AM - 07:00 AM">06:00 AM - 07:00 AM</option>
                                    <option value="07:00 AM - 08:00 AM">07:00 AM - 08:00 AM</option>
                                    <option value="08:00 AM - 09:00 AM">08:00 AM - 09:00 AM</option>
                                    <option value="09:00 AM - 10:00 AM">09:00 AM - 10:00 AM</option>
                                    <option value="10:00 AM - 11:00 AM">10:00 AM - 11:00 AM</option>
                                    <option value="11:00 AM - 12:00 PM">11:00 AM - 12:00 PM</option>
                                    <option value="12:00 PM - 01:00 PM">12:00 PM - 01:00 PM</option>
                                    <option value="01:00 PM - 02:00 PM">01:00 PM - 02:00 PM</option>
                                    <option value="02:00 PM - 03:00 PM">02:00 PM - 03:00 PM</option>
                                    <option value="03:00 PM - 04:00 PM">03:00 PM - 04:00 PM</option>
                                    <option value="04:00 PM - 05:00 PM">04:00 PM - 05:00 PM</option>
                                    <option value="05:00 PM - 06:00 PM">05:00 PM - 06:00 PM</option>
                                    <option value="06:00 PM - 07:00 PM">06:00 PM - 07:00 PM</option>
                                    <option value="07:00 PM - 08:00 PM">07:00 PM - 08:00 PM</option>
                                    <option value="08:00 PM - 09:00 PM">08:00 PM - 09:00 PM</option>
                                    <option value="09:00 PM - 10:00 PM">09:00 PM - 10:00 PM</option>
                                    <option value="10:00 PM - 11:00 PM">10:00 PM - 11:00 PM</option>
                                    <option value="11:00 PM - 12:00 AM">11:00 PM - 12:00 AM</option>
                                </select>

                                <input class="reservation_input" type="number" placeholder="<?php echo e(__('user.Number of person')); ?>" name="person" required>
                                <button type="submit"><?php echo e(__('user.Send Request')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!--=============================
        MENU END
    ==============================-->


    <!-- CART POPUT START -->
    <div class="wsus__cart_popup">
        <div class="modal fade" id="cartModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                class="fal fa-times"></i></button>
                        <div class="load_product_modal_response">
                            <img src="<?php echo e(asset('uploads/website-images/Spinner-1s-200px.gif')); ?>" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- CART POPUT END -->
    <!--=============================
        OFFER ITEM END
    ==============================-->

    <?php echo $__env->yieldContent('public-content'); ?>


    <!--=============================
        BRAND START
    ==============================-->
    <section class="wsus__brand" style="background: url(<?php echo e(asset($setting->partner_background)); ?>);">
        <div class="wsus__brand_overlay">
            <div class="container">
                <div class="row brand_slider wow fadeInUp" data-wow-duration="1s">
                    <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-2">
                            <?php if($partner->link): ?>
                            <a class="wsus__single_brand" href="<?php echo e($partner->link); ?>">
                                <img src="<?php echo e(asset($partner->image)); ?>" alt="brand" class="img-fluid w-100">
                            </a>
                            <?php else: ?>
                            <a class="wsus__single_brand" href="javascript:;">
                                <img src="<?php echo e(asset($partner->image)); ?>" alt="brand" class="img-fluid w-100">
                            </a>
                            <?php endif; ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BRAND END
    ==============================-->


    <!--=============================
        FOOTER START
    ==============================-->
    <footer style="background: url(<?php echo e(asset($footer->footer_background)); ?>);">
        <div class="footer_overlay pt_100 xs_pt_70 pb_100 xs_pb_70">
            <div class="container wow fadeInUp" data-wow-duration="1s">
                <div class="row justify-content-between">
                    <div class="col-lg-4 col-sm-8 col-md-6">
                        <div class="wsus__footer_content">
                            <a class="footer_logo" href="<?php echo e(route('home')); ?>">
                                <img src="<?php echo e(asset($setting->footer_logo)); ?>" alt="UniFood" class="img-fluid w-100">
                            </a>
                            <span><?php echo e($footer->about_us_translated); ?></span>
                            <p class="info"><i class="far fa-map-marker-alt"></i> <?php echo e($footer->address_translated); ?></p>
                            <a class="info" href="callto:<?php echo e($footer->phone); ?>"><i class="fas fa-phone-alt"></i>
                                <?php echo e($footer->phone); ?></a>
                            <a class="info" href="mailto:<?php echo e($footer->email); ?>"><i class="fas fa-envelope"></i>
                                <?php echo e($footer->email); ?></a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-sm-4 col-md-6">
                        <div class="wsus__footer_content">
                            <h3><?php echo e(__('user.Important Link')); ?></h3>
                            <ul>
                                <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                                <li><a href="<?php echo e(route('about-us')); ?>"><?php echo e(__('user.About Us')); ?></a></li>
                                <li><a href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('user.Contact Us')); ?></a></li>
                                <li><a href="<?php echo e(route('our-chef')); ?>"><?php echo e(__('user.Our Chef')); ?></a></li>
                                <li><a href="<?php echo e(route('our-chef')); ?>"><?php echo e(__('user.Dashboard')); ?></a></li>

                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-2 col-sm-4 col-md-6 order-sm-4 order-lg-3">
                        <div class="wsus__footer_content">
                            <h3><?php echo e(__('user.Help Link')); ?></h3>
                            <ul>
                                <li><a href="<?php echo e(route('blogs')); ?>"><?php echo e(__('user.Our Blogs')); ?></a></li>
                                <li><a href="<?php echo e(route('testimonial')); ?>"><?php echo e(__('user.Testimonial')); ?></a></li>
                                <li><a href="<?php echo e(route('faq')); ?>"><?php echo e(__('user.FAQ')); ?></a></li>
                                <li><a href="<?php echo e(route('privacy-policy')); ?>"><?php echo e(__('user.Privacy and Policy')); ?></a></li>
                                <li><a href="<?php echo e(route('terms-and-condition')); ?>"><?php echo e(__('user.Terms anc Conditions')); ?></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-8 col-md-6 order-lg-4">
                        <div class="wsus__footer_content">
                            <h3><?php echo e(__('user.Subscribe to Newsletter')); ?></h3>
                            <form id="subscribe_form">
                                <?php echo csrf_field(); ?>
                                <input type="email" placeholder="<?php echo e(__('user.Email')); ?>" name="email">
                                <button id="subscribe_btn" type="submit"><i class="fas fa-paper-plane"></i></button>
                            </form>
                            <div class="wsus__footer_social_link">
                                <h5><?php echo e(__('user.Follow us')); ?>:</h5>
                                <ul class="d-flex flex-wrap">
                                    <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social_link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e($social_link->link); ?>"><i class="<?php echo e($social_link->icon); ?>"></i></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="wsus__footer_bottom d-flex flex-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="wsus__footer_bottom_text d-flex flex-wrap justify-content-between">
                            <p><?php echo e($footer->copyright_translated); ?></p>
                            <ul class="d-flex flex-wrap">
                                <li><a href="<?php echo e(__('user.faq')); ?>"><?php echo e(__('user.FAQ')); ?></a></li>
                                <li><a href="<?php echo e(__('user.payment')); ?>"><?php echo e(__('user.Payment')); ?></a></li>
                                <li><a href="<?php echo e(__('user.checkout')); ?>"><?php echo e(__('user.Checkout')); ?></a></li>
                                <li><a href="<?php echo e(__('user.dashboard')); ?>"><?php echo e(__('user.Dashboard')); ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--=============================
        FOOTER END
    ==============================-->


    <!--=============================
        SCROLL BUTTON START
    ==============================-->
    <div class="wsus__scroll_btn">
        <?php echo e(__('user.Go to top')); ?>

    </div>
    <!--=============================
        SCROLL BUTTON END
    ==============================-->

    <?php if($tawk_setting->status == 1): ?>
    <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='<?php echo e($tawk_setting->chat_link); ?>';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>
    <?php endif; ?>


    <?php if($cookie_consent->status == 1): ?>
    <script src="<?php echo e(asset('user/js/cookieconsent.min.js')); ?>"></script>

    <script>
    window.addEventListener("load",function(){window.wpcc.init({"border":"<?php echo e($cookie_consent->border); ?>","corners":"<?php echo e($cookie_consent->corners); ?>","colors":{"popup":{"background":"<?php echo e($cookie_consent->background_color); ?>","text":"<?php echo e($cookie_consent->text_color); ?> !important","border":"<?php echo e($cookie_consent->border_color); ?>"},"button":{"background":"<?php echo e($cookie_consent->btn_bg_color); ?>","text":"<?php echo e($cookie_consent->btn_text_color); ?>"}},"content":{"href":"<?php echo e(route('privacy-policy')); ?>","message":"<?php echo e($cookie_consent->message); ?>","link":"<?php echo e($cookie_consent->link_text); ?>","button":"<?php echo e($cookie_consent->btn_text); ?>"}})});
    </script>
    <?php endif; ?>


    <!--bootstrap js-->
    <script src="<?php echo e(asset('user/js/bootstrap.bundle.min.js')); ?>"></script>
    <!--font-awesome js-->
    <script src="<?php echo e(asset('user/js/Font-Awesome.js')); ?>"></script>
    <!-- slick slider -->
    <script src="<?php echo e(asset('user/js/slick.min.js')); ?>"></script>
    <!-- isotop js -->
    <script src="<?php echo e(asset('user/js/isotope.pkgd.min.js')); ?>"></script>
    <!-- simplyCountdownjs -->
    <script src="<?php echo e(asset('user/js/simplyCountdown.js')); ?>"></script>
    <!-- counter up js -->
    <script src="<?php echo e(asset('user/js/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/js/jquery.countup.min.js')); ?>"></script>
    <!-- nice select js -->
    <script src="<?php echo e(asset('user/js/jquery.nice-select.min.js')); ?>"></script>
    <!-- venobox js -->
    <script src="<?php echo e(asset('user/js/venobox.min.js')); ?>"></script>
    <!-- sticky sidebar js -->
    <script src="<?php echo e(asset('user/js/sticky_sidebar.js')); ?>"></script>
    <!-- wow js -->
    <script src="<?php echo e(asset('user/js/wow.min.js')); ?>"></script>
    <!-- ex zoom js -->
    <script src="<?php echo e(asset('user/js/jquery.exzoom.js')); ?>"></script>

    <script src="<?php echo e(asset('backend/js/bootstrap-datepicker.min.js')); ?>"></script>

    <!--main/custom js-->
    <script src="<?php echo e(asset('user/js/main.js')); ?>"></script>

    <script src="<?php echo e(asset('toastr/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/select2.min.js')); ?>"></script>

    <script>
        <?php if(Session::has('messege')): ?>
        var type="<?php echo e(Session::get('alert-type','info')); ?>"
        switch(type){
            case 'info':
                toastr.info("<?php echo e(Session::get('messege')); ?>");
                break;
            case 'success':
                toastr.success("<?php echo e(Session::get('messege')); ?>");
                break;
            case 'warning':
                toastr.warning("<?php echo e(Session::get('messege')); ?>");
                break;
            case 'error':
                toastr.error("<?php echo e(Session::get('messege')); ?>");
                break;
        }
        <?php endif; ?>
    </script>

    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                toastr.error('<?php echo e($error); ?>');
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            
            $("#setLanguage").on('change', function(e){
                this.submit();
            });
            
            $(".first_menu_product").click();

            $('.select2').select2();
            $('.modal_select2').select2({
                dropdownParent: $("#address_modal")
            });

            $('.datepicker').datepicker({
                format: 'yyyy-mm-dd',
                startDate: '-Infinity'
            });

            $(document).on('click', '.mini-item-remove', function () {
                let root_li = $(this).parents('li');
                let rowid = root_li.data('mini-item-rowid');
                root_li.remove();

                let is_cart_page = "<?php echo e(Route::is('cart') ? 'yes' : 'no'); ?>";
                if(is_cart_page == 'yes'){
                    $(".main-cart-item-"+rowid).remove();
                    calculate_total();
                }

                calculate_mini_total();

                $.ajax({
                    type: 'get',
                    url: "<?php echo e(url('/remove-cart-item')); ?>" + "/" + rowid,
                    success: function (response) {
                        toastr.success(response.message);

                        let ready_to_reload = "<?php echo e(Route::is('checkout') || Route::is('payment') ? 'yes' : 'no'); ?>"
                        if(ready_to_reload == 'yes'){
                            window.location.reload();
                        }
                    },
                    error: function(response) {
                        if(response.status == 500){
                            toastr.error("<?php echo e(__('user.Server error occured')); ?>")
                        }

                        if(response.status == 403){
                            toastr.error("<?php echo e(__('user.Server error occured')); ?>")
                        }
                    }
                });
            });
    
            $("#subscribe_form").on('submit', function(e){
                    e.preventDefault();
                    var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                    if(isDemo == 0){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    $("#subscribe_btn").prop("disabled", true);
                    $("#subscribe_btn").html(`<i class="fas fa-spinner"></i>`);

                    $.ajax({
                        type: 'POST',
                        data: $('#subscribe_form').serialize(),
                        url: "<?php echo e(route('subscribe-request')); ?>",
                        success: function (response) {
                            toastr.success(response.message)
                            $("#subscribe_form").trigger("reset");
                            $("#subscribe_btn").prop("disabled", false);
                            $("#subscribe_btn").html(`<i class="fas fa-paper-plane"></i>`);
                        },
                        error: function(response) {
                            $("#subscribe_btn").prop("disabled", false);
                            $("#subscribe_btn").html(`<i class="fas fa-paper-plane"></i>`);

                            if(response.status == 403){
                                if(response.responseJSON.message)toastr.error(response.responseJSON.message)
                            }
                        }
                    });
                })
        });
    })(jQuery);

    function calculate_mini_total(){
        let mini_sub_total = 0;
        let mini_total_item = 0;
        $(".mini-input-price").each(function () {
            let current_val = $(this).val();
            mini_sub_total = parseInt(mini_sub_total) + parseInt(current_val);
            mini_total_item = parseInt(mini_total_item) + parseInt(1);
        });

        $(".mini_sub_total").html(`<?php echo e($currency_icon); ?>${mini_sub_total}`);
        $(".topbar_cart_qty").html(mini_total_item);
        $(".mini_cart_body_item").html(`<?php echo e(__('user.Total Item')); ?>(${mini_total_item})`);

        let mini_empty_cart = `<div class="wsus__menu_cart_header">
                <h5><?php echo e(__('user.Your cart is empty')); ?></h5>
                <span class="close_cart"><i class="fal fa-times"></i></span>
            </div>
            `;

        if(mini_total_item == 0){
            $(".wsus__menu_cart_boody").html(mini_empty_cart)
        }
    }

    function load_product_model(product_id){

        $("#preloader").addClass('preloader')
        $(".img").removeClass('d-none')

        $.ajax({
            type: 'get',
            url: "<?php echo e(url('/load-product-modal')); ?>" + "/" + product_id,
            success: function (response) {
                $("#preloader").removeClass('preloader')
                $(".img").addClass('d-none')
                $(".load_product_modal_response").html(response)
                $("#cartModal").modal('show');
            },
            error: function(response) {
                toastr.error("<?php echo e(__('user.Server error occured')); ?>")
            }
        });
    }

    function add_to_wishlist(id){
        $.ajax({
            type: 'get',
            url: "<?php echo e(url('/add-to-wishlist')); ?>" + "/" + id,
            success: function (response) {
                toastr.success("<?php echo e(__('user.Wishlist added successfully')); ?>");
            },
            error: function(response) {
                if(response.status == 500){
                    toastr.error("<?php echo e(__('user.Server error occured')); ?>")
                }

                if(response.status == 403){
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }
    function before_auth_wishlist(){
        toastr.error("<?php echo e(__('user.Please login first')); ?>")
    }

</script>

</body>

</html>
<?php /**PATH D:\laragon\www\unifood\script_content\main_files\resources\views/layout.blade.php ENDPATH**/ ?>