
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($seo_setting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public-content'); ?>

    <!--=============================
        BANNER START
    ==============================-->
    <section class="wsus__banner" style="background: url(<?php echo e(asset($slider->slider_background)); ?>);">
        <div class="wsus__banner_overlay">
            <span class="banner_shape_1">
                <img src="<?php echo e(asset($slider->foreground_image_one)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <span class="banner_shape_2">
                <img src="<?php echo e(asset($slider->foreground_image_two)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <div class="row banner_slider">
                <?php $__currentLoopData = $slider->sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12">
                        <div class="wsus__banner_slider">
                            <div class=" container">
                                <div class="row">
                                    <div class="col-xl-5 col-md-5 col-lg-5">
                                        <div class="wsus__banner_img wow fadeInLeft" data-wow-duration="1s">
                                            <div class="img">
                                                <img src="<?php echo e(asset($slider_item->image)); ?>" alt="food item" class="img-fluid w-100">
                                                <span style="background: url(<?php echo e(asset('user/images/offer_shapes.png')); ?>);">
                                                    <?php echo e($slider_item->offer_text_translated); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-5 col-md-7 col-lg-6">
                                        <div class="wsus__banner_text wow fadeInRight" data-wow-duration="1s">
                                            <h1><?php echo e($slider_item->title_one_translated); ?></h1>
                                            <h3><?php echo e($slider_item->title_two_translated); ?></h3>
                                            <p><?php echo e($slider_item->description_translated); ?></p>
                                            <ul class="d-flex flex-wrap">
                                                <li><a class="common_btn" href="<?php echo e($slider_item->link); ?>"><?php echo e(__('user.Shop now')); ?></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        BANNER END
    ==============================-->


    <!--=============================
        WHY CHOOSE START
    ==============================-->
    <?php if($service->status): ?>
    <section class="wsus__why_choose">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $service->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-md-6 col-lg-4">
                        <div class="wsus__choose_single d-flex flex-wrap align-items-center justify-content-between">
                            <div class="icon icon_1">
                                <i class="<?php echo e($service_item->icon); ?>"></i>
                            </div>
                            <div class="text">
                                <h3><?php echo e($service_item->title_translated); ?></h3>
                                <p><?php echo e($service_item->description_translated); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    <!--=============================
        WHY CHOOSE END
    ==============================-->


    <!--=============================
        OFFER ITEM START
    ==============================-->
    <?php if($today_special_product->status): ?>
        <section class="wsus__offer_item mt_95 xs_mt_65">
            <span class="banner_shape_3">
                <img src="<?php echo e(asset($today_special_product->image)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <div class="container">
                <div class="row wow fadeInUp" data-wow-duration="1s">
                    <div class="col-md-8 col-lg-7 col-xl-6 m-auto text-center">
                        <div class="wsus__section_heading mb_50">
                            <h4><?php echo e($today_special_product->short_title); ?></h4>
                            <h2><?php echo e($today_special_product->long_title); ?></h2>
                            <span>
                                <img src="<?php echo e(asset('user/images/heading_shapes.png')); ?>" alt="shapes" class="img-fluid w-100">
                            </span>
                            <p><?php echo e($today_special_product->description); ?></p>
                        </div>
                    </div>
                </div>
                <div class="row offer_item_slider wow fadeInUp" data-wow-duration="1s">
                    <?php $__currentLoopData = $today_special_product->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4">
                            <div class="wsus__offer_item_single" style="background: url(<?php echo e(asset($product->thumb_image)); ?>);">

                                <?php if($product->is_offer): ?>
                                <span><?php echo e($product->offer); ?>% off</span>
                                <?php endif; ?>

                                <a class="title" href="<?php echo e(route('show-product', $product->slug)); ?>"><?php echo e($product->name_translated); ?></a>
                                <p><?php echo e($product->short_description_translated); ?></p>
                                <ul class="d-flex flex-wrap">
                                    <li><a href="javascript:;" onclick="load_product_model(<?php echo e($product->id); ?>)"><i
                                                class="fas fa-shopping-basket"></i></a></li>

                                    <?php if(auth()->guard('web')->check()): ?>
                                    <li><a href="javascript:;" onclick="add_to_wishlist(<?php echo e($product->id); ?>)"><i class="fal fa-heart"></i></a></li>
                                    <?php else: ?>
                                    <li><a href="javascript:;" onclick="before_auth_wishlist(<?php echo e($product->id); ?>)"><i class="fal fa-heart"></i></a></li>
                                    <?php endif; ?>


                                    <li><a href="<?php echo e(route('show-product', $product->slug)); ?>"><i class="far fa-eye"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </section>
    <?php endif; ?>

    <!--=============================
        MENU ITEM START
    ==============================-->
    <?php if($menu_section->status): ?>
        <section class="wsus__menu mt_95 xs_mt_65">
            <span class="banner_shape_1">
                <img src="<?php echo e(asset($menu_section->left_image)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <span class="banner_shape_2">
                <img src="<?php echo e(asset($menu_section->right_image)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <div class="container">

                <div class="row wow fadeInUp" data-wow-duration="1s">
                    <div class="col-md-8 col-lg-7 col-xl-6 m-auto text-center">
                        <div class="wsus__section_heading mb_45">
                            <h4><?php echo e($menu_section->short_title); ?></h4>
                            <h2><?php echo e($menu_section->long_title); ?></h2>
                            <span>
                                <img src="<?php echo e(asset('user/images/heading_shapes.png')); ?>" alt="shapes" class="img-fluid w-100">
                            </span>
                            <p><?php echo e($menu_section->description); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row wow fadeInUp" data-wow-duration="1s">
                    <div class="col-12">
                        <div class="menu_filter d-flex flex-wrap justify-content-center">
                            <?php $__currentLoopData = $menu_section->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $menu_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button class="<?php echo e($index == 0 ? 'first_menu_product' : ''); ?>" data-filter=".category_<?php echo e($menu_category->id); ?>"><?php echo e($menu_category->name_translated); ?></button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <div class="row grid">
                    <?php $__currentLoopData = $menu_section->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $menu_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-sm-6 col-lg-4 category_<?php echo e($menu_product->category_id); ?> wow fadeInUp " data-wow-duration="1s">
                            <div class="wsus__menu_item">
                                <div class="wsus__menu_item_img">
                                    <img src="<?php echo e(asset($menu_product->thumb_image)); ?>" alt="menu" class="img-fluid w-100">
                                    <a class="category" href="#"><?php echo e($menu_product->category->name_translated); ?></a>
                                </div>
                                <div class="wsus__menu_item_text">
                                    <p class="rating">
                                        <?php
                                            if ($menu_product->total_review > 0) {
                                                $average = $menu_product->average_rating;

                                                $int_average = intval($average);

                                                $next_value = $int_average + 1;
                                                $review_point = $int_average;
                                                $half_review=false;
                                                if($int_average < $average && $average < $next_value){
                                                    $review_point= $int_average + 0.5;
                                                    $half_review=true;
                                                }
                                            }
                                        ?>

                                        <?php if($menu_product->total_review > 0): ?>
                                            <?php for($i = 1; $i <=5; $i++): ?>
                                                <?php if($i <= $review_point): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php elseif($i> $review_point ): ?>
                                                    <?php if($half_review==true): ?>
                                                        <i class="fas fa-star-half-alt"></i>
                                                        <?php
                                                            $half_review=false
                                                        ?>
                                                    <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        <?php else: ?>
                                            <i class="far fa-star"></i>
                                            <i class="far fa-star"></i>
                                            <i class="far fa-star"></i>
                                            <i class="far fa-star"></i>
                                            <i class="far fa-star"></i>
                                        <?php endif; ?>
                                        <span><?php echo e($menu_product->total_review); ?></span>
                                    </p>
                                    <a class="title" href="<?php echo e(route('show-product', $menu_product->slug)); ?>"><?php echo e($menu_product->name_translated); ?></a>

                                    <?php if($menu_product->is_offer): ?>
                                        <h5 class="price"><?php echo e($currency_icon); ?><?php echo e($menu_product->offer_price); ?> <del><?php echo e($currency_icon); ?><?php echo e($menu_product->price); ?></del> </h5>
                                    <?php else: ?>
                                        <h5 class="price"><?php echo e($currency_icon); ?><?php echo e($menu_product->price); ?></h5>
                                    <?php endif; ?>

                                    <ul class="d-flex flex-wrap justify-content-center">
                                        <li><a href="javascript:;" onclick="load_product_model(<?php echo e($menu_product->id); ?>)"><i
                                                    class="fas fa-shopping-basket"></i></a></li>


                                        <?php if(auth()->guard('web')->check()): ?>
                                        <li><a href="javascript:;" onclick="add_to_wishlist(<?php echo e($menu_product->id); ?>)"><i class="fal fa-heart"></i></a></li>
                                        <?php else: ?>
                                        <li><a href="javascript:;" onclick="before_auth_wishlist(<?php echo e($menu_product->id); ?>)"><i class="fal fa-heart"></i></a></li>
                                        <?php endif; ?>

                                        <li><a href="<?php echo e(route('show-product', $menu_product->slug)); ?>"><i class="far fa-eye"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        MENU ITEM END
    ==============================-->


    <!--=============================
        ADD SLIDER START
    ==============================-->
    <?php if($advertisement->status): ?>
        <section class="wsus__add_slider mt_100 xs_mt_70">
            <div class="container">
                <div class="row add_slider wow fadeInUp" data-wow-duration="1s">
                    <?php $__currentLoopData = $advertisement->banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad_banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4">
                            <a href="<?php echo e($ad_banner->link); ?>" class="wsus__add_slider_single" style="background: url(<?php echo e(url($ad_banner->image)); ?>);">
                                <div class="text">
                                    <h3><?php echo e($ad_banner->title_translated); ?></h3>
                                    <p><?php echo e($ad_banner->description_translated); ?></p>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        ADD SLIDER END
    ==============================-->


    <!--=============================
        TEAM START
    ==============================-->
    <?php if($our_chef->status): ?>
        <section class="wsus__team pt_95 xs_pt_65 pb_150 xs_pb_120" style="background: url(<?php echo e(asset('user/images/chefs_bg.jpg')); ?>);">
            <span class="banner_shape_1">
                <img src="<?php echo e(asset($our_chef->left_image)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <span class="banner_shape_2">
                <img src="<?php echo e(asset($our_chef->right_image)); ?>" alt="shape" class="img-fluid w-100">
            </span>
            <div class="container">
                <div class="row wow fadeInUp" data-wow-duration="1s">
                    <div class="col-md-8 col-lg-7 col-xl-6 m-auto text-center">
                        <div class="wsus__section_heading mb_25">
                            <h4><?php echo e($our_chef->short_title); ?></h4>
                            <h2><?php echo e($our_chef->long_title); ?></h2>
                            <span>
                                <img src="<?php echo e(asset('user/images/heading_shapes.png')); ?>" alt="shapes" class="img-fluid w-100">
                            </span>
                            <p><?php echo e($our_chef->description); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row team_slider">
                    <?php $__currentLoopData = $our_chef->chefs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $single_chef): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 wow fadeInUp" data-wow-duration="1s">
                            <div class="wsus__single_team">
                                <div class="wsus__single_team_img">
                                    <img src="<?php echo e(asset($single_chef->image)); ?>" alt="team" class="img-fluid w-100">
                                </div>
                                <div class="wsus__single_team_text">
                                    <h4><?php echo e($single_chef->name_translated); ?></h4>
                                    <p><?php echo e($single_chef->designation_translated); ?></p>
                                    <ul class="d-flex flex-wrap justify-content-center">
                                        <?php if($single_chef->facebook): ?>
                                            <li><a href="<?php echo e($single_chef->facebook); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                        <?php endif; ?>

                                        <?php if($single_chef->linkedin): ?>
                                            <li><a href="<?php echo e($single_chef->linkedin); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                                        <?php endif; ?>

                                        <?php if($single_chef->twitter): ?>
                                            <li><a href="<?php echo e($single_chef->twitter); ?>"><i class="fab fa-twitter"></i></a></li>
                                        <?php endif; ?>

                                        <?php if($single_chef->instagram): ?>
                                            <li><a href="<?php echo e($single_chef->instagram); ?>"><i class="fab fa-instagram"></i></a></li>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        TEAM END
    ==============================-->


    <!--=============================
        DOWNLOAD APP START
    ==============================-->

    <?php if($app_section->status): ?>
        <section class="wsus__download mt_100 xs_mt_70">
            <div class="container">
                <div class="wsus__download_bg" style="background: url(<?php echo e(asset($app_section->home1_background)); ?>);">
                    <div class="wsus__download_overlay">
                        <div class="row justify-content-between">
                            <div class="col-xl-5 col-lg-6 wow fadeInUp" data-wow-duration="1s">
                                <div class="wsus__download_text">
                                    <div class="wsus__section_heading mb_25">
                                        <h2><?php echo e($app_section->title); ?></h2>
                                        <p><?php echo e($app_section->description); ?></p>
                                    </div>
                                    <ul class="d-flex flex-wrap">
                                        <li>
                                            <a href="<?php echo e($app_section->play_store_link); ?>">
                                                <i class="fab fa-google-play"></i>
                                                <p> <span><?php echo e(__('user.download from')); ?></span> <?php echo e(__('user.google play')); ?> </p>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e($app_section->app_store_link); ?>">
                                                <i class="fab fa-apple"></i>
                                                <p> <span><?php echo e(__('user.download from')); ?></span> <?php echo e(__('user.apple store')); ?> </p>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6 wow fadeInUp" data-wow-duration="1s">
                                <div class="wsus__download_img">
                                    <img src="<?php echo e(asset($app_section->image)); ?>" alt="download" class="img-fluid w-100">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        DOWNLOAD APP END
    ==============================-->


    <!--=============================
        COUNTER START
    ==============================-->
    <?php if($counter->status): ?>
        <section class="wsus__counter mt_100 xs_mt_70" style="background: url(<?php echo e(asset($counter->background_image)); ?>);">
            <div class="wsus__counter_overlay pt_100 xs_pt_70 pb_100 xs_pb_70">
                <div class="container">
                    <div class="row">
                        <?php $__currentLoopData = $counter->counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $single_counter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-3 col-sm-6 col-lg-3 wow fadeInUp" data-wow-duration="1s">
                                <div class="wsus__single_counter">
                                    <i class="<?php echo e($single_counter->icon); ?>"></i>
                                    <div class="text">
                                        <h2 class="counter"><?php echo e($single_counter->quantity); ?></h2>
                                        <p><?php echo e($single_counter->title_translated); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        COUNTER END
    ==============================-->


    <!--=============================
       TESTIMONIAL  START
    ==============================-->
    <?php if($testimonial->status): ?>
        <section class="wsus__testimonial pt_90 xs_pt_60 mb_150 xs_mb_120">
            <div class="container">

                <div class="row wow fadeInUp" data-wow-duration="1s">
                    <div class="col-md-8 col-lg-7 col-xl-6 m-auto text-center">
                        <div class="wsus__section_heading mb_40">
                            <h4><?php echo e($testimonial->short_title); ?></h4>
                            <h2><?php echo e($testimonial->long_title); ?></h2>
                            <span>
                                <img src="<?php echo e(asset('user/images/heading_shapes.png')); ?>" alt="shapes" class="img-fluid w-100">
                            </span>
                            <p><?php echo e($testimonial->description); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row testi_slider">
                    <?php $__currentLoopData = $testimonial->testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $single_testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 wow fadeInUp" data-wow-duration="1s">
                            <div class="wsus__single_testimonial">
                                <div class="wsus__testimonial_header d-flex flex-wrap align-items-center">
                                    <div class="img">
                                        <img src="<?php echo e(asset($single_testimonial->image)); ?>" alt="clients" class="img-fluid w-100">
                                    </div>
                                    <div class="text">
                                        <h4><?php echo e($single_testimonial->name_translated); ?></h4>
                                        <p><?php echo e($single_testimonial->designation_translated); ?></p>
                                    </div>
                                </div>
                                <div class="wsus__single_testimonial_body">
                                    <p class="feedback"><?php echo e($single_testimonial->comment_translated); ?></p>
                                    <span class="rating">
                                        <?php for($i = 1; $i <=5 ; $i++): ?>
                                            <?php if($i <= $single_testimonial->rating ): ?>
                                            <i class="fas fa-star"></i>
                                            <?php else: ?>
                                            <i class="far fa-star"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </span>
                                </div>
                                <div class="wsus__testimonial_product">
                                    <img src="<?php echo e(asset($single_testimonial->product_image)); ?>" alt="product" class="img-fluid w-100">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        TESTIMONIAL END
    ==============================-->

    <!--=============================
        BLOG START
    ==============================-->

    <?php if($blog->status): ?>
        <section class="wsus__blog" style="background: url(<?php echo e(asset($blog->home1_background)); ?>);">
            <div class="wsus__blog_overlay pt_95 xs_pt_65 pb_100 xs_pb_70">
                <div class="container">

                    <div class="row wow fadeInUp" data-wow-duration="1s">
                        <div class="col-md-8 col-lg-7 col-xl-6 m-auto text-center">
                            <div class="wsus__section_heading mb_25">
                                <h4><?php echo e($blog->short_title); ?></h4>
                                <h2><?php echo e($blog->long_title); ?></h2>
                                <span>
                                    <img src="<?php echo e(asset('user/images/heading_shapes.png')); ?>" alt="shapes" class="img-fluid w-100">
                                </span>
                                <p><?php echo e($blog->description); ?></p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <?php $__currentLoopData = $blog->blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $single_blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-sm-6 col-lg-4 wow fadeInUp" data-wow-duration="1s">
                                <div class="wsus__single_blog">
                                    <a href="<?php echo e(route('show-blog', $single_blog->slug)); ?>" class="wsus__single_blog_img">
                                        <img src="<?php echo e(asset($single_blog->image)); ?>" alt="blog" class="img-fluid w-100">
                                    </a>
                                    <div class="wsus__single_blog_text">
                                        <a class="category" href="<?php echo e(route('blogs', ['category' => $single_blog->category->slug ])); ?>"><?php echo e($single_blog->category->name_translated); ?></a>
                                        <ul class="d-flex flex-wrap mt_15">
                                            <li><i class="fas fa-user"></i><?php echo e(__('user.by admin')); ?></li>
                                            <li><i class="fas fa-calendar-alt"></i> <?php echo e($single_blog->created_at->format('d M Y')); ?></li>
                                            <li><i class="fas fa-comments"></i> <?php echo e($single_blog->total_comment); ?><?php echo e(__('user.comment')); ?></li>
                                        </ul>
                                        <a class="title" href="<?php echo e(route('show-blog', $single_blog->slug)); ?>"><?php echo e($single_blog->title_translated); ?></a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!--=============================
        BLOG END
    ==============================-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\unifood\script_content\main_files\resources\views/index.blade.php ENDPATH**/ ?>