
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <p>Setup Your User Account</p>
            <div>
                <a class="btn btn-outline-primary <?php if(!session()->has('step-4-complete')): ?> disabled <?php endif; ?>" href="<?php echo e(route('setup.configuration')); ?>">Next &raquo;</a>
            </div>
        </div>
        <div class="card-body">
            <form id="account_form" autocomplete="off">
                <div class="mb-3">
                    <label>Full Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" id="name" class="form-control" value="<?php echo e(old('name',$admin?->name)); ?>"
                        placeholder="Enter Your Full Name">
                </div>
                <div class="mb-3">
                    <label>E-Mail <span class="text-danger">*</span></label>
                    <input type="text" name="email" id="email" class="form-control" value="<?php echo e(old('email',$admin?->email)); ?>"
                        placeholder="Enter Your E-Mail Address">
                </div>
                <div class="mb-3">
                    <label>Password <span class="text-danger">*</span></label>
                    <input autocomplete="new-password" id="password" type="password" name="password"
                        value="<?php echo e(old('password')); ?>" class="form-control" placeholder="Enter Your Password">
                </div>
                <div class="mb-3">
                    <label>Re-Type Password <span class="text-danger">*</span></label>
                    <input autocomplete="new-password" id="confirm_password" type="password" name="confirm_password"
                        value="<?php echo e(old('password')); ?>" class="form-control" placeholder="Confirm Your Password">
                </div>
                <button type="submit" id="submit_btn" class="btn btn-primary">Create Account</button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $(document).on('submit', '#account_form', async function(e) {
                e.preventDefault();
                let submit_btn, name, email, password, confirm_password;
                submit_btn = $('#submit_btn');
                name = $('#name').val();
                email = $('#email').val();
                password = $('#password').val();
                confirm_password = $('#confirm_password').val();

                if ($.trim(name) === '') {
                    toastr.warning("Name is required");
                } else if ($.trim(email) === '') {
                    toastr.warning("Email is required");
                } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
                    toastr.warning('Invalid email format');
                } else if ($.trim(password) === '') {
                    toastr.warning("Password is required");
                } else if ($.trim(password) !== $.trim(confirm_password)) {
                    toastr.warning("Password & Confirm Password Must be same");
                } else {
                    submit_btn.html(
                        'Creating... <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>'
                    ).prop('disabled', true);
                    try {
                        let data = {
                            name: name,
                            email: email,
                            password: password,
                            confirm_password: confirm_password,
                        };
                        const res = await makeAjaxRequest(data, "<?php echo e(route('setup.account.submit')); ?>");
                        if (res.success) {
                            toastr.success(res.message);
                            submit_btn.addClass('btn-success').html('Redirecting...');
                            window.location.href = "<?php echo e(route('setup.configuration')); ?>";
                        } else {
                            submit_btn.html('Account Create').prop('disabled', false);
                            toastr.error(res.message);
                        }
                    } catch (error) {
                        submit_btn.html('Account Create').prop('disabled', false);
                        $.each(error.errors, function(index, value) {
                            toastr.error(value);
                        });
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('setup.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\unifood\script_content\main_files\installer\views/setup/account.blade.php ENDPATH**/ ?>