<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, target-densityDpi=device-dpi" />

    @yield('title')
    @yield('meta')

    <link rel="icon" type="image/png" href="{{ asset($setting->favicon) }}">
    <link rel="stylesheet" href="{{ asset('user/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/spacing.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/nice-select.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/venobox.min.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/animate.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/jquery.exzoom.css') }}">
    <link rel="stylesheet" href="{{ asset('toastr/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('user/css/responsive.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/select2.min.css') }}">


    @include('theme_color')
    @if (session()->get('text_direction') == 'rtl')
    <link rel="stylesheet" href="{{ asset('user/css/rtl.css') }}">
    @endif

    <!--jquery library js-->
    <script src="{{ asset('user/js/jquery-3.6.3.min.js') }}"></script>
    <script src="{{ asset('user/js/sweetalert2@11.js') }}"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>


    @if ($googleAnalytic->status == 1)
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ $googleAnalytic->analytic_id }}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '{{ $googleAnalytic->analytic_id }}');
    </script>
    @endif

    @if ($facebookPixel->status == 1)
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '{{ $facebookPixel->app_id }}');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id={{ $facebookPixel->app_id }}&ev=PageView&noscript=1"
    /></noscript>
    @endif


</head>

<body>

    <div class="" id="preloader">
        <div class="img d-none">
            <img src="{{ asset('uploads/website-images/Spinner.gif') }}" alt="UniFood" class="img-fluid">
        </div>
    </div>

    <!--=============================
        TOPBAR START
    ==============================-->
    <section class="wsus__topbar">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-md-6 d-none d-md-block">
                    <ul class="wsus__topbar_info d-flex flex-wrap">
                        <li><a href="mailto:{{ $footer->email }}"><i class="fas fa-envelope"></i> {{ $footer->email }}</a>
                        </li>
                        <li><a href="callto:{{ $footer->phone }}"><i class="fas fa-phone-alt"></i> {{ $footer->phone }}</a></li>
                    </ul>
                </div>
                <div class="col-xl-6 col-md-6">
                    <div class="topbar_right">
                        <div class="topbar_language">
                            <form id="setLanguage" action="{{ route('set-language') }}">
                                <select id="select_js3" name="code">
                                    @forelse($languages as $language)
                                    <option value="{{$language->code}}"{{ session()->get('lang') == $language->code ? 'selected' : '' }}>{{ $language->name }}</option>
                                    @empty
                                    <option value="en">English</option>
                                    @endforelse
                                </select>
                            </form>
                        </div>
                        <ul class="topbar_icon d-flex flex-wrap">
                            @foreach ($social_links as $social_link)
                            <li><a href="{{ $social_link->link }}"><i class="{{ $social_link->icon }}"></i></a></li>
                            @endforeach
                        </ul>   
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        TOPBAR END
    ==============================-->


    <!--=============================
        MENU START
    ==============================-->
    <nav class="navbar navbar-expand-lg main_menu">
        <div class="container">
            <a class="navbar-brand" href="{{ route('home') }}">
                <img src="{{ asset($setting->logo) }}" alt="UniFood" class="img-fluid">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <i class="far fa-bars"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav m-auto">

                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('home') }}">{{__('user.Home')}}</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('about-us') }}">{{__('user.About Us')}}</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('products') }}">{{__('user.Products')}}</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="#">{{__('user.pages')}} <i class="far fa-plus"></i></a>
                        <ul class="droap_menu">

                            <li>
                                <a href="{{ route('our-chef') }}">{{__('user.Our chef')}}</a>
                            </li>

                            <li><a href="{{ route('testimonial') }}">{{__('user.Testimonial')}}</a></li>

                            <li><a href="{{ route('faq') }}">{{__('user.FAQs')}}</a></li>

                            <li><a href="{{ route('privacy-policy') }}">{{__('user.privacy policy')}}</a></li>
                            <li><a href="{{ route('terms-and-condition') }}">{{__('user.terms and condition')}}</a></li>

                            @foreach ($custom_pages as $custom_page)
                            <li><a href="{{ route('show-page', $custom_page->slug) }}">{{ $custom_page->page_name_translated }}</a></li>
                            @endforeach
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('blogs') }}">{{__('user.Blogs')}}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('contact-us') }}">{{__('user.contact us')}}</a>
                    </li>
                </ul>
                <ul class="menu_icon d-flex flex-wrap">
                    <li>
                        <a href="javascript:;" class="menu_search"><i class="far fa-search"></i></a>
                        <div class="wsus__search_form">
                            <form action="{{ route('products') }}">
                                <span class="close_search"><i class="far fa-times"></i></span>
                                <input name="search" type="text" placeholder="{{__('user.Type your keyword')}}">
                                <button type="submit">{{__('user.search')}}</button>
                            </form>
                        </div>
                    </li>
                    @php
                        $mini_cart_contents = Cart::content();
                    @endphp
                    <li>
                        <a class="cart_icon"><i class="fas fa-shopping-basket"></i> <span class="topbar_cart_qty">{{ count($mini_cart_contents) }}</span></a>
                    </li>
                    <li>
                        <a href="{{ route('dashboard') }}"><i class="fas fa-user"></i></a>
                    </li>
                    <li>
                        @auth('web')
                        <a class="common_btn" href="#" data-bs-toggle="modal"
                        data-bs-target="#staticBackdrop">{{__('user.reservation')}}</a>
                        @else
                        <a class="common_btn" href="{{ route('login') }}">{{__('user.reservation')}}</a>
                        @endauth

                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="wsus__menu_cart_area">
        <div class="wsus__menu_cart_boody">

            @if (count($mini_cart_contents) == 0)
                <div class="wsus__menu_cart_header">
                    <h5>{{__('user.Your cart is empty')}}</h5>
                    <span class="close_cart"><i class="fal fa-times"></i></span>
                </div>
            @else
                <div>
                    <div class="wsus__menu_cart_header">
                        <h5 class="mini_cart_body_item">{{__('user.Total Item')}}({{ count($mini_cart_contents) }})</h5>
                        <span class="close_cart"><i class="fal fa-times"></i></span>
                    </div>
                    <ul class="mini_cart_list">
                        @php
                            $mini_sub_total = 0;
                        @endphp
                        @foreach ($mini_cart_contents as $mini_cart_content)
                            <li class="min-item-{{ $mini_cart_content->rowId }}" data-mini-item-rowid="{{ $mini_cart_content->rowId }}">
                                <div class="menu_cart_img">
                                    <img src="{{ asset($mini_cart_content->options->image) }}" alt="menu" class="img-fluid w-100">
                                </div>
                                <div class="menu_cart_text">
                                    <a class="title" href="{{ route('show-product', $mini_cart_content->options->slug) }}">{{ $mini_cart_content->name }} </a>
                                    <p class="size">{{ $mini_cart_content->options->size }}</p>
                                    @foreach ($mini_cart_content->options->optional_items as $optional_item)
                                    <span class="extra">{{ $optional_item['optional_name'] }} (+{{ $currency_icon }}{{ $optional_item['optional_price'] }})</span>
                                    @endforeach

                                    @php
                                        $item_price = $mini_cart_content->price * $mini_cart_content->qty;
                                        $item_total = $item_price + $mini_cart_content->options->optional_item_price;
                                        $mini_sub_total += $item_total;
                                    @endphp

                                    <p class="price mini-price-{{ $mini_cart_content->rowId }}">{{ $currency_icon }}{{ $item_total }}</p>
                                </div>
                                <input type="hidden" class="mini-input-price set-mini-input-price-{{ $mini_cart_content->rowId }}" value="{{ $item_total }}">
                                <span class="del_icon mini-item-remove"><i class="fal fa-times"></i></span>
                            </li>
                        @endforeach

                    </ul>
                    <p class="subtotal">{{__('user.Sub Total')}} <span class="mini_sub_total">{{ $currency_icon }}{{ $mini_sub_total }}</span></p>
                    <a class="cart_view" href="{{ route('cart') }}"> {{__('user.view cart')}}</a>
                    <a class="checkout" href="{{ route('checkout') }}">{{__('user.checkout')}}</a>
                </div>
            @endif

        </div>
    </div>

    @auth('web')
        <div class="wsus__reservation">
            <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
                aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">{{__('user.Book a Table')}}</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form class="wsus__reservation_form" method="POST" action="{{ route('store-reservation') }}">
                                @csrf
                                @php
                                    $auth_user = Auth::guard('web')->user();
                                @endphp
                                @if ($auth_user->phone == null)
                                <input class="reservation_input" type="text" placeholder="{{__('user.Phone')}}" name="phone" required>
                                @endif
                                <input class="reservation_input datepicker" type="text" autocomplete="off" name="reserve_date" required placeholder="{{__('user.Select date')}}">

                                <select class="reservation_input" id="select_js" required name="reserve_time">
                                    <option value="">{{__('user.Select Time')}}</option>
                                    <option value="12:00 AM - 01:00 AM">12:00 AM - 01:00 AM</option>
                                    <option value="01:00 AM - 02:00 AM">01:00 AM - 02:00 AM</option>
                                    <option value="02:00 AM - 03:00 AM">02:00 AM - 03:00 AM</option>
                                    <option value="03:00 AM - 04:00 AM">03:00 AM - 04:00 AM</option>
                                    <option value="04:00 AM - 05:00 AM">04:00 AM - 05:00 AM</option>
                                    <option value="05:00 AM - 06:00 AM">05:00 AM - 06:00 AM</option>
                                    <option value="06:00 AM - 07:00 AM">06:00 AM - 07:00 AM</option>
                                    <option value="07:00 AM - 08:00 AM">07:00 AM - 08:00 AM</option>
                                    <option value="08:00 AM - 09:00 AM">08:00 AM - 09:00 AM</option>
                                    <option value="09:00 AM - 10:00 AM">09:00 AM - 10:00 AM</option>
                                    <option value="10:00 AM - 11:00 AM">10:00 AM - 11:00 AM</option>
                                    <option value="11:00 AM - 12:00 PM">11:00 AM - 12:00 PM</option>
                                    <option value="12:00 PM - 01:00 PM">12:00 PM - 01:00 PM</option>
                                    <option value="01:00 PM - 02:00 PM">01:00 PM - 02:00 PM</option>
                                    <option value="02:00 PM - 03:00 PM">02:00 PM - 03:00 PM</option>
                                    <option value="03:00 PM - 04:00 PM">03:00 PM - 04:00 PM</option>
                                    <option value="04:00 PM - 05:00 PM">04:00 PM - 05:00 PM</option>
                                    <option value="05:00 PM - 06:00 PM">05:00 PM - 06:00 PM</option>
                                    <option value="06:00 PM - 07:00 PM">06:00 PM - 07:00 PM</option>
                                    <option value="07:00 PM - 08:00 PM">07:00 PM - 08:00 PM</option>
                                    <option value="08:00 PM - 09:00 PM">08:00 PM - 09:00 PM</option>
                                    <option value="09:00 PM - 10:00 PM">09:00 PM - 10:00 PM</option>
                                    <option value="10:00 PM - 11:00 PM">10:00 PM - 11:00 PM</option>
                                    <option value="11:00 PM - 12:00 AM">11:00 PM - 12:00 AM</option>
                                </select>

                                <input class="reservation_input" type="number" placeholder="{{__('user.Number of person')}}" name="person" required>
                                <button type="submit">{{__('user.Send Request')}}</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endauth
    <!--=============================
        MENU END
    ==============================-->


    <!-- CART POPUT START -->
    <div class="wsus__cart_popup">
        <div class="modal fade" id="cartModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                class="fal fa-times"></i></button>
                        <div class="load_product_modal_response">
                            <img src="{{ asset('uploads/website-images/Spinner-1s-200px.gif') }}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- CART POPUT END -->
    <!--=============================
        OFFER ITEM END
    ==============================-->

    @yield('public-content')


    <!--=============================
        BRAND START
    ==============================-->
    <section class="wsus__brand" style="background: url({{ asset($setting->partner_background) }});">
        <div class="wsus__brand_overlay">
            <div class="container">
                <div class="row brand_slider wow fadeInUp" data-wow-duration="1s">
                    @foreach ($partners as $partner)
                        <div class="col-xl-2">
                            @if ($partner->link)
                            <a class="wsus__single_brand" href="{{ $partner->link }}">
                                <img src="{{ asset($partner->image) }}" alt="brand" class="img-fluid w-100">
                            </a>
                            @else
                            <a class="wsus__single_brand" href="javascript:;">
                                <img src="{{ asset($partner->image) }}" alt="brand" class="img-fluid w-100">
                            </a>
                            @endif

                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BRAND END
    ==============================-->


    <!--=============================
        FOOTER START
    ==============================-->
    <footer style="background: url({{ asset($footer->footer_background) }});">
        <div class="footer_overlay pt_100 xs_pt_70 pb_100 xs_pb_70">
            <div class="container wow fadeInUp" data-wow-duration="1s">
                <div class="row justify-content-between">
                    <div class="col-lg-4 col-sm-8 col-md-6">
                        <div class="wsus__footer_content">
                            <a class="footer_logo" href="{{ route('home') }}">
                                <img src="{{ asset($setting->footer_logo) }}" alt="UniFood" class="img-fluid w-100">
                            </a>
                            <span>{{ $footer->about_us_translated }}</span>
                            <p class="info"><i class="far fa-map-marker-alt"></i> {{ $footer->address_translated }}</p>
                            <a class="info" href="callto:{{ $footer->phone }}"><i class="fas fa-phone-alt"></i>
                                {{ $footer->phone }}</a>
                            <a class="info" href="mailto:{{ $footer->email }}"><i class="fas fa-envelope"></i>
                                {{ $footer->email }}</a>
                        </div>
                    </div>
                    <div class="col-lg-2 col-sm-4 col-md-6">
                        <div class="wsus__footer_content">
                            <h3>{{__('user.Important Link')}}</h3>
                            <ul>
                                <li><a href="{{ route('home') }}">{{__('user.Home')}}</a></li>
                                <li><a href="{{ route('about-us') }}">{{__('user.About Us')}}</a></li>
                                <li><a href="{{ route('contact-us') }}">{{__('user.Contact Us')}}</a></li>
                                <li><a href="{{ route('our-chef') }}">{{__('user.Our Chef')}}</a></li>
                                <li><a href="{{ route('our-chef') }}">{{__('user.Dashboard')}}</a></li>

                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-2 col-sm-4 col-md-6 order-sm-4 order-lg-3">
                        <div class="wsus__footer_content">
                            <h3>{{__('user.Help Link')}}</h3>
                            <ul>
                                <li><a href="{{ route('blogs') }}">{{__('user.Our Blogs')}}</a></li>
                                <li><a href="{{ route('testimonial') }}">{{__('user.Testimonial')}}</a></li>
                                <li><a href="{{ route('faq') }}">{{__('user.FAQ')}}</a></li>
                                <li><a href="{{ route('privacy-policy') }}">{{__('user.Privacy and Policy')}}</a></li>
                                <li><a href="{{ route('terms-and-condition') }}">{{__('user.Terms anc Conditions')}}</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-8 col-md-6 order-lg-4">
                        <div class="wsus__footer_content">
                            <h3>{{__('user.Subscribe to Newsletter')}}</h3>
                            <form id="subscribe_form">
                                @csrf
                                <input type="email" placeholder="{{__('user.Email')}}" name="email">
                                <button id="subscribe_btn" type="submit"><i class="fas fa-paper-plane"></i></button>
                            </form>
                            <div class="wsus__footer_social_link">
                                <h5>{{__('user.Follow us')}}:</h5>
                                <ul class="d-flex flex-wrap">
                                    @foreach ($social_links as $social_link)
                                    <li><a href="{{ $social_link->link }}"><i class="{{ $social_link->icon }}"></i></a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="wsus__footer_bottom d-flex flex-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="wsus__footer_bottom_text d-flex flex-wrap justify-content-between">
                            <p>{{ $footer->copyright_translated }}</p>
                            <ul class="d-flex flex-wrap">
                                <li><a href="{{__('user.faq')}}">{{__('user.FAQ')}}</a></li>
                                <li><a href="{{__('user.payment')}}">{{__('user.Payment')}}</a></li>
                                <li><a href="{{__('user.checkout')}}">{{__('user.Checkout')}}</a></li>
                                <li><a href="{{__('user.dashboard')}}">{{__('user.Dashboard')}}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--=============================
        FOOTER END
    ==============================-->


    <!--=============================
        SCROLL BUTTON START
    ==============================-->
    <div class="wsus__scroll_btn">
        {{__('user.Go to top')}}
    </div>
    <!--=============================
        SCROLL BUTTON END
    ==============================-->

    @if ($tawk_setting->status == 1)
    <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
            var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
            s1.async=true;
            s1.src='{{ $tawk_setting->chat_link }}';
            s1.charset='UTF-8';
            s1.setAttribute('crossorigin','*');
            s0.parentNode.insertBefore(s1,s0);
        })();
    </script>
    @endif


    @if ($cookie_consent->status == 1)
    <script src="{{ asset('user/js/cookieconsent.min.js') }}"></script>

    <script>
    window.addEventListener("load",function(){window.wpcc.init({"border":"{{ $cookie_consent->border }}","corners":"{{ $cookie_consent->corners }}","colors":{"popup":{"background":"{{ $cookie_consent->background_color }}","text":"{{ $cookie_consent->text_color }} !important","border":"{{ $cookie_consent->border_color }}"},"button":{"background":"{{ $cookie_consent->btn_bg_color }}","text":"{{ $cookie_consent->btn_text_color }}"}},"content":{"href":"{{ route('privacy-policy') }}","message":"{{ $cookie_consent->message }}","link":"{{ $cookie_consent->link_text }}","button":"{{ $cookie_consent->btn_text }}"}})});
    </script>
    @endif


    <!--bootstrap js-->
    <script src="{{ asset('user/js/bootstrap.bundle.min.js') }}"></script>
    <!--font-awesome js-->
    <script src="{{ asset('user/js/Font-Awesome.js') }}"></script>
    <!-- slick slider -->
    <script src="{{ asset('user/js/slick.min.js') }}"></script>
    <!-- isotop js -->
    <script src="{{ asset('user/js/isotope.pkgd.min.js') }}"></script>
    <!-- simplyCountdownjs -->
    <script src="{{ asset('user/js/simplyCountdown.js') }}"></script>
    <!-- counter up js -->
    <script src="{{ asset('user/js/jquery.waypoints.min.js') }}"></script>
    <script src="{{ asset('user/js/jquery.countup.min.js') }}"></script>
    <!-- nice select js -->
    <script src="{{ asset('user/js/jquery.nice-select.min.js') }}"></script>
    <!-- venobox js -->
    <script src="{{ asset('user/js/venobox.min.js') }}"></script>
    <!-- sticky sidebar js -->
    <script src="{{ asset('user/js/sticky_sidebar.js') }}"></script>
    <!-- wow js -->
    <script src="{{ asset('user/js/wow.min.js') }}"></script>
    <!-- ex zoom js -->
    <script src="{{ asset('user/js/jquery.exzoom.js') }}"></script>

    <script src="{{ asset('backend/js/bootstrap-datepicker.min.js') }}"></script>

    <!--main/custom js-->
    <script src="{{ asset('user/js/main.js') }}"></script>

    <script src="{{ asset('toastr/toastr.min.js') }}"></script>
    <script src="{{ asset('backend/js/select2.min.js') }}"></script>

    <script>
        @if(Session::has('messege'))
        var type="{{Session::get('alert-type','info')}}"
        switch(type){
            case 'info':
                toastr.info("{{ Session::get('messege') }}");
                break;
            case 'success':
                toastr.success("{{ Session::get('messege') }}");
                break;
            case 'warning':
                toastr.warning("{{ Session::get('messege') }}");
                break;
            case 'error':
                toastr.error("{{ Session::get('messege') }}");
                break;
        }
        @endif
    </script>

    @if ($errors->any())
        @foreach ($errors->all() as $error)
            <script>
                toastr.error('{{ $error }}');
            </script>
        @endforeach
    @endif

<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            
            $("#setLanguage").on('change', function(e){
                this.submit();
            });
            
            $(".first_menu_product").click();

            $('.select2').select2();
            $('.modal_select2').select2({
                dropdownParent: $("#address_modal")
            });

            $('.datepicker').datepicker({
                format: 'yyyy-mm-dd',
                startDate: '-Infinity'
            });

            $(document).on('click', '.mini-item-remove', function () {
                let root_li = $(this).parents('li');
                let rowid = root_li.data('mini-item-rowid');
                root_li.remove();

                let is_cart_page = "{{ Route::is('cart') ? 'yes' : 'no' }}";
                if(is_cart_page == 'yes'){
                    $(".main-cart-item-"+rowid).remove();
                    calculate_total();
                }

                calculate_mini_total();

                $.ajax({
                    type: 'get',
                    url: "{{ url('/remove-cart-item') }}" + "/" + rowid,
                    success: function (response) {
                        toastr.success(response.message);

                        let ready_to_reload = "{{ Route::is('checkout') || Route::is('payment') ? 'yes' : 'no' }}"
                        if(ready_to_reload == 'yes'){
                            window.location.reload();
                        }
                    },
                    error: function(response) {
                        if(response.status == 500){
                            toastr.error("{{__('user.Server error occured')}}")
                        }

                        if(response.status == 403){
                            toastr.error("{{__('user.Server error occured')}}")
                        }
                    }
                });
            });
    
            $("#subscribe_form").on('submit', function(e){
                    e.preventDefault();
                    var isDemo = "{{ env('APP_MODE') }}"
                    if(isDemo == 0){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    $("#subscribe_btn").prop("disabled", true);
                    $("#subscribe_btn").html(`<i class="fas fa-spinner"></i>`);

                    $.ajax({
                        type: 'POST',
                        data: $('#subscribe_form').serialize(),
                        url: "{{ route('subscribe-request') }}",
                        success: function (response) {
                            toastr.success(response.message)
                            $("#subscribe_form").trigger("reset");
                            $("#subscribe_btn").prop("disabled", false);
                            $("#subscribe_btn").html(`<i class="fas fa-paper-plane"></i>`);
                        },
                        error: function(response) {
                            $("#subscribe_btn").prop("disabled", false);
                            $("#subscribe_btn").html(`<i class="fas fa-paper-plane"></i>`);

                            if(response.status == 403){
                                if(response.responseJSON.message)toastr.error(response.responseJSON.message)
                            }
                        }
                    });
                })
        });
    })(jQuery);

    function calculate_mini_total(){
        let mini_sub_total = 0;
        let mini_total_item = 0;
        $(".mini-input-price").each(function () {
            let current_val = $(this).val();
            mini_sub_total = parseInt(mini_sub_total) + parseInt(current_val);
            mini_total_item = parseInt(mini_total_item) + parseInt(1);
        });

        $(".mini_sub_total").html(`{{ $currency_icon }}${mini_sub_total}`);
        $(".topbar_cart_qty").html(mini_total_item);
        $(".mini_cart_body_item").html(`{{__('user.Total Item')}}(${mini_total_item})`);

        let mini_empty_cart = `<div class="wsus__menu_cart_header">
                <h5>{{__('user.Your cart is empty')}}</h5>
                <span class="close_cart"><i class="fal fa-times"></i></span>
            </div>
            `;

        if(mini_total_item == 0){
            $(".wsus__menu_cart_boody").html(mini_empty_cart)
        }
    }

    function load_product_model(product_id){

        $("#preloader").addClass('preloader')
        $(".img").removeClass('d-none')

        $.ajax({
            type: 'get',
            url: "{{ url('/load-product-modal') }}" + "/" + product_id,
            success: function (response) {
                $("#preloader").removeClass('preloader')
                $(".img").addClass('d-none')
                $(".load_product_modal_response").html(response)
                $("#cartModal").modal('show');
            },
            error: function(response) {
                toastr.error("{{__('user.Server error occured')}}")
            }
        });
    }

    function add_to_wishlist(id){
        $.ajax({
            type: 'get',
            url: "{{ url('/add-to-wishlist') }}" + "/" + id,
            success: function (response) {
                toastr.success("{{__('user.Wishlist added successfully')}}");
            },
            error: function(response) {
                if(response.status == 500){
                    toastr.error("{{__('user.Server error occured')}}")
                }

                if(response.status == 403){
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }
    function before_auth_wishlist(){
        toastr.error("{{__('user.Please login first')}}")
    }

</script>

</body>

</html>
