@extends('admin.master_layout')
@section('title')
<title>{{__('admin.Categories')}}</title>
@endsection
@section('admin-content')
<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>{{__('admin.Categories')}}</h1>
        </div>

        <div class="section-body">
            <a href="{{ route('admin.product-category.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i>
                {{__('admin.Add New')}}</a>
            <div class="row mt-4">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive table-invoice">
                                <table class="table table-striped" id="dataTable">
                                    <thead>
                                        <tr>
                                            <th>{{__('admin.SN')}}</th>
                                            <th>{{__('admin.Name')}}</th>
                                            <th>{{__('admin.Show Homepage')}}</th>
                                            <th>{{__('admin.Status')}}</th>
                                            <th>{{__('admin.Translations')}}</th>
                                            <th>{{__('admin.Action')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($categories as $index => $category)
                                        <tr>
                                            <td>{{ ++$index }}</td>
                                            <td>{{ $category->name }}</td>
                                            <td>
                                                @if ($category->show_homepage == 1)
                                                <span class="badge badge-success">{{__('admin.Yes')}}</span>
                                                @else
                                                <span class="badge badge-danger">{{__('admin.No')}}</span>

                                                @endif
                                            </td>

                                            <td>
                                                @forelse ($languages as $language)
                                                <a href="{{ route('admin.translation.product-category.create', [
                                            'code' => $language->code,
                                            'id' => $category->id
                                          ]) }}"><i class="fa {{ $category?->translation($language->code)->first()?->name ? 'fa-check' : 'fa-edit' }}"></i> {{ strtoupper($language->code) }}</a>
                                                @if(!$loop->last)
                                                |
                                                @endif
                                                @empty
                                                <a href="{{ route('admin.translation.product-category.create', [
                                            'code' => app()->getLocale(),
                                            'id' => $category->id
                                          ]) }}"><i
                                                        class="fa {{ $category?->translation(app()->getLocale())->first()?->name ? 'fa-check' : 'fa-edit' }}"></i> {{ strtoupper(app()->getLocale()) }}</a>
                                                @endforelse
                                            </td>

                                            <td>
                                                @if($category->status == 1)
                                                <a href="javascript:;"
                                                    onclick="changeProductCategoryStatus({{ $category->id }})">
                                                    <input id="status_toggle" type="checkbox" checked
                                                        data-toggle="toggle" data-on="{{__('admin.Active')}}"
                                                        data-off="{{__('admin.Inactive')}}" data-onstyle="success"
                                                        data-offstyle="danger">
                                                </a>

                                                @else
                                                <a href="javascript:;"
                                                    onclick="changeProductCategoryStatus({{ $category->id }})">
                                                    <input id="status_toggle" type="checkbox" data-toggle="toggle"
                                                        data-on="{{__('admin.Active')}}"
                                                        data-off="{{__('admin.Inactive')}}" data-onstyle="success"
                                                        data-offstyle="danger">
                                                </a>

                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.product-category.edit',$category->id) }}"
                                                    class="btn btn-primary btn-sm"><i class="fa fa-edit"
                                                        aria-hidden="true"></i></a>

                                                @if ($category->products->count() == 0)
                                                <a href="javascript:;" data-toggle="modal" data-target="#deleteModal"
                                                    class="btn btn-danger btn-sm"
                                                    onclick="deleteData({{ $category->id }})"><i class="fa fa-trash"
                                                        aria-hidden="true"></i></a>
                                                @else
                                                <a href="javascript:;" data-toggle="modal"
                                                    data-target="#canNotDeleteModal" class="btn btn-danger btn-sm"
                                                    disabled><i class="fa fa-trash" aria-hidden="true"></i></a>
                                                @endif
                                            </td>

                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>

<!-- Modal -->
<div class="modal fade" id="canNotDeleteModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                {{__('admin.You can not delete this category. Because there are one or more products has been created in this category.')}}
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{__('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>

<script>
    function deleteData(id) {
        $("#deleteForm").attr("action", '{{ url("admin/product-category/") }}' + "/" + id)
    }

    function changeProductCategoryStatus(id) {
        var isDemo = "{{ env('APP_MODE') }}"
        if (isDemo == 0) {
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type: "put",
            data: {
                _token: '{{ csrf_token() }}'
            },
            url: "{{url('/admin/product-category-status/')}}" + "/" + id,
            success: function (response) {
                toastr.success(response)
            },
            error: function (err) {}
        })
    }

</script>
@endsection
