@extends('admin.master_layout')
@section('title')
<title>{{__('admin.Our Chef')}}</title>
@endsection
@section('admin-content')
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1>{{__('admin.Our Chef')}}</h1>
          </div>

          <div class="section-body">
            <a href="{{ route('admin.our-chef.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i> {{__('admin.Add New')}}</a>
            <div class="row mt-4">
                <div class="col">
                  <div class="card">
                    <div class="card-body">
                      <div class="table-responsive table-invoice">
                        <table class="table table-striped" id="dataTable">
                            <thead>
                                <tr>
                                    <th>{{__('admin.SN')}}</th>
                                    <th>{{__('admin.Name')}}</th>
                                    <th>{{__('admin.Designation')}}</th>
                                    <th>{{__('admin.Image')}}</th>
                                    <th>{{__('admin.Translations')}}</th>
                                    <th>{{__('admin.Status')}}</th>
                                    <th>{{__('admin.Action')}}</th>
                                  </tr>
                            </thead>
                            <tbody>
                                @foreach ($chef_list as $index => $chef)
                                    <tr>
                                        <td>{{ ++$index }}</td>
                                        <td>{{ $chef->name }}</td>
                                        <td>{{ $chef->designation }}</td>
                                        <td><img src="{{ asset($chef->image) }}" alt="" class="rounded-circle"></td>
                                        <td>
                                          @forelse ($languages as $language)
                                            <a href="{{ route('admin.translation.our-chef.create', ['code' => $language->code, 'id' => $chef->id]) }}"><i class="fa {{ $chef->translation($language->code)?->first()?->name ? 'fa-check' : 'fa-edit' }}"></i>
                                                {{ strtoupper($language->code) }}</a>
                                            @if(!$loop->last)
                                            |
                                            @endif
                                            @empty
                                            <a href="{{ route('admin.translation.our-chef.create', [
                                          'code' => app()->getLocale(), 'id' => $chef->id
                                      ]) }}"><i class="fa {{ $chef->translation(app()->getLocale())->first()?->name ? 'fa-check' : 'fa-edit' }}"></i>
                                                {{ strtoupper(app()->getLocale()) }}</a>
                                            @endforelse
                                        </td>
                                        <td>
                                            @if($chef->status == 1)
                                            <a href="javascript:;" onclick="changeFeatureStatus({{ $chef->id }})">
                                                <input id="status_toggle" type="checkbox" checked data-toggle="toggle" data-on="{{__('admin.Active')}}" data-off="{{__('admin.InActive')}}" data-onstyle="success" data-offstyle="danger">
                                            </a>
                                            @else
                                            <a href="javascript:;" onclick="changeFeatureStatus({{ $chef->id }})">
                                                <input id="status_toggle" type="checkbox" data-toggle="toggle" data-on="{{__('admin.Active')}}" data-off="{{__('admin.InActive')}}" data-onstyle="success" data-offstyle="danger">
                                            </a>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.our-chef.edit',$chef->id) }}" class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                            <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData({{ $chef->id }})"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        </td>
                                    </tr>
                                  @endforeach
                            </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    function deleteData(id){
        $("#deleteForm").attr("action",'{{ url("admin/our-chef/") }}'+"/"+id)
    }
    function changeFeatureStatus(id){
        var isDemo = "{{ env('APP_MODE') }}"
        if(isDemo == 0){
            toastr.error('This Is Demo Version. You Can Not Change Anything');
            return;
        }
        $.ajax({
            type:"put",
            data: { _token : '{{ csrf_token() }}' },
            url:"{{url('/admin/our-chef-status/')}}"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){
            }
        })
    }
</script>
@endsection
