<?php

use Illuminate\Support\Facades\Route;
use Installer\Controllers\InstallerController;
use Installer\Controllers\PuchaseVerificationController;

//all setup route
Route::prefix( 'setup' )->middleware( 'setup' )->group( function () {
    Route::get( 'verify', [PuchaseVerificationController::class, 'index'] )->name( 'setup.verify' );
    Route::post( 'verify', [PuchaseVerificationController::class, 'validatePurchase'] )->name( 'setup.checkParchase' );

    Route::get( 'requirements', [InstallerController::class, 'requirements'] )->name( 'setup.requirements' );
    Route::get( 'database', [InstallerController::class, 'database'] )->name( 'setup.database' );
    Route::post( 'database-submit', [InstallerController::class, 'databaseSubmit'] )->name( 'setup.database.submit' );
    Route::get( 'account', [InstallerController::class, 'account'] )->name( 'setup.account' );
    Route::post( 'account-submit', [InstallerController::class, 'accountSubmit'] )->name( 'setup.account.submit' );
    Route::get( 'configuration', [InstallerController::class, 'configuration'] )->name( 'setup.configuration' );
    Route::get( 'smtp', [InstallerController::class, 'smtp'] )->name( 'setup.smtp' );
    Route::post( 'smtp', [InstallerController::class, 'smtpSetup'] )->name( 'setup.smtp.update' );
    Route::post( 'smtp/skip', [InstallerController::class, 'smtpSkip'] )->name( 'setup.smtp.skip' );
    Route::post( 'configuration-submit', [InstallerController::class, 'configurationSubmit'] )->name( 'setup.configuration.submit' );
    Route::get( 'complete', [InstallerController::class, 'setupComplete'] )->name( 'setup.complete' );

} );
Route::get( 'setup/lunch/{type}', [InstallerController::class, 'launchWebsite'] )->name( 'website.completed' );
