<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Setting;
use App\Models\FooterSocialLink;
use App\Models\Footer;
use App\Models\GoogleAnalytic;
use App\Models\FacebookPixel;
use App\Models\Partner;
use App\Models\FooterLink;
use App\Models\CustomPage;
use App\Models\CookieConsent;
use App\Models\Language;
use App\Models\TawkChat;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        try {
            // Cache key
            $cacheKey = 'app_data';

            // Retrieve data from cache or database
            $data = Cache::remember($cacheKey, now()->addMinutes(460), function () {
                return [
                    'setting' => Setting::first(),
                    'social_links' => FooterSocialLink::all(),
                    'footer' => Footer::with('translation')->first(),
                    'googleAnalytic' => GoogleAnalytic::first(),
                    'facebookPixel' => FacebookPixel::first(),
                    'partners' => Partner::where('status', 1)->get(),
                    'custom_pages' => CustomPage::with('translation')->where('status', 1)->get(),
                    'cookieConsent' => CookieConsent::first(),
                    'tawk_setting' => TawkChat::first(),
                    'languages' => Language::all(),
                ];
            });
            View::composer('*', function ($view) use ($data) {

                // Share data with views
                $view->with('currency_icon', $data['setting']->currency_icon);
                $view->with('setting', $data['setting']);
                $view->with('social_links', $data['social_links']);
                $view->with('footer', $data['footer']);
                $view->with('googleAnalytic', $data['googleAnalytic']);
                $view->with('facebookPixel', $data['facebookPixel']);
                $view->with('partners', $data['partners']);
                $view->with('breadcrumb', $data['setting']->breadcrumb_image);
                $view->with('default_user_avatar', $data['setting']->default_avatar);
                $view->with('custom_pages', $data['custom_pages']);
                $view->with('cookie_consent', $data['cookieConsent']);
                $view->with('tawk_setting', $data['tawk_setting']);
                $view->with('languages', $data['languages']);
            });
            $default_lang = Cache::rememberForever('default_lang', function () {
                $default_lang_info = Language::where('status', 1)->first();
                if ($default_lang_info) {
                    session(['lang' => $default_lang_info->code]);
                    session(['text_direction' => $default_lang_info->direction]);
                    return $default_lang_info->code;
                }
                return null;
            });
            if ($default_lang) {
                config(['app.locale' => $default_lang]);
            } else {
                config(['app.locale' => 'en']);
            }
        } catch (\Throwable $th) {
            try {
                $setting = Setting::first();
                $social_links = FooterSocialLink::all();
                $footer = Footer::with('translation')->first();
                $googleAnalytic = GoogleAnalytic::first();
                $facebookPixel = FacebookPixel::first();
                $partners = Partner::where('status', 1)->get();
                $custom_pages = CustomPage::with('translation')->where('status', 1)->get();
                $cookieConsent = CookieConsent::first();
                $tawk_setting = TawkChat::first();
                $languages = Language::all();

                View::composer('*', function ($view) use ($setting,$social_links,$footer,$googleAnalytic,$facebookPixel,$partners,$custom_pages,$cookieConsent,$tawk_setting,$languages,) {
                    $view->with('currency_icon', $setting->currency_icon);
                    $view->with('setting', $setting);
                    $view->with('social_links', $social_links);
                    $view->with('footer', $footer);
                    $view->with('googleAnalytic', $googleAnalytic);
                    $view->with('facebookPixel', $facebookPixel);
                    $view->with('partners', $partners);
                    $view->with('breadcrumb', $setting->breadcrumb_image);
                    $view->with('default_user_avatar', $setting->default_avatar);
                    $view->with('custom_pages', $custom_pages);
                    $view->with('cookie_consent', $cookieConsent);
                    $view->with('tawk_setting', $tawk_setting);
                    $view->with('languages', $languages);
                });
            } catch (\Throwable $th) {
                
            }
        }
    }
}
