<?php

namespace App\Models;

use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    use HasFactory;

    public function getTitleOneTranslatedAttribute()
    {
        if ($this->translation?->title_one) {
            return $this->translation->title_one;
        }
        return $this->title_one;
    }

    public function getTitleTwoTranslatedAttribute()
    {
        if ($this->translation?->title_two) {
            return $this->translation->title_two;
        }
        return $this->title_two;
    }

    public function getDescriptionTranslatedAttribute()
    {
        if ($this->translation?->description) {
            return $this->translation->description;
        }
        return $this->description;
    }

    public function getOfferTextTranslatedAttribute()
    {
        if ($this->translation?->offer_text) {
            return $this->translation->offer_text;
        }
        return $this->offer_text;
    }

    public function translation($language = null)
    {
        if ($language == null) {
            $language = getSessionLanguage();
        }

        return $this->hasOne(SliderTranslation::class, 'slider_id', 'id')->where('language', '=', $language);
    }

    public function translations()
    {
        return $this->hasMany(SliderTranslation::class);
    }

    public static function boot()
    {
        parent::boot();

        static::created(function ($model) {
            $defaultTranslation = SliderTranslation::firstOrCreate([
                'language' => config('app.locale'),
                'slider_id' => $model->id,
            ]);
            $defaultTranslation->title_one = $model->title_one;
            $defaultTranslation->title_two = $model->title_two;
            $defaultTranslation->description = $model->description;
            $defaultTranslation->offer_text = $model->offer_text;
            $defaultTranslation->save();
        });

        static::updated(function ($model) {
            $defaultTranslation = SliderTranslation::firstOrCreate([
                'language' => config('app.locale'),
                'slider_id' => $model->id,
            ]);
            $defaultTranslation->title_one = $model->title_one;
            $defaultTranslation->title_two = $model->title_two;
            $defaultTranslation->description = $model->description;
            $defaultTranslation->offer_text = $model->offer_text;
            $defaultTranslation->save();
        });

        static::deleted(function ($model) {
            try {
                if ($model->translations) {
                    $model->translations()->delete();
                }
            } catch (Exception $e) {}
        });
    }
}
