<?php

namespace App\Http\Controllers\WEB\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PayPal\Api\Amount;
use PayPal\Api\Details;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;
use PayPal\Rest\ApiContext;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Api\PaymentExecution;

use App\Models\BreadcrumbImage;
use App\Models\Country;
use App\Models\CountryState;
use App\Models\City;
use App\Models\BillingAddress;
use App\Models\ShippingAddress;
use App\Models\Vendor;
use App\Models\ShippingMethod;
use App\Models\DeliveryArea;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\OrderProductVariant;
use App\Models\OrderAddress;
use App\Models\Product;
use App\Models\Setting;
use App\Models\StripePayment;
use App\Mail\OrderSuccessfully;
use App\Helpers\MailHelper;
use App\Models\EmailTemplate;
use App\Models\PaypalPayment;
use App\Models\Coupon;
use App\Models\ShoppingCart;

use App\Models\Shipping;
use App\Models\Address;
use App\Models\ShoppingCartVariant;


use App\Models\RazorpayPayment;
use App\Models\Flutterwave;
use App\Models\PaystackAndMollie;
use App\Models\InstamojoPayment;
use App\Models\ProductVariantItem;
use App\Models\FlashSaleProduct;
use App\Models\FlashSale;
use Srmklive\PayPal\Services\PayPal as PayPalClient;

use Str;
use Cart;
use Mail;
use Session;
use Auth;
use Exception;

class PaypalController extends Controller
{
    public function calculate_amount($address_id){
        $sub_total = 0;
        $coupon_price = 0.00;
        $delivery_charge = Session::get('delivery_charge');

        $cart_contents = Cart::content();
        foreach ($cart_contents as $index => $cart_content){
            $item_price = $cart_content->price * $cart_content->qty;
            $item_total = $item_price + $cart_content->options->optional_item_price;
            $sub_total += $item_total;
        }

        if(Session::get('coupon_price') && Session::get('offer_type')){
            if(Session::get('offer_type') == 1) {
                $coupon_price = Session::get('coupon_price');
                $coupon_price = ($coupon_price / 100) * $sub_total;
            }else {
                $coupon_price = Session::get('coupon_price');
            }
        }

        $grand_total = ($sub_total - $coupon_price) + $delivery_charge;

        return array(
            'sub_total' => $sub_total,
            'coupon_price' => $coupon_price,
            'delivery_charge' => $delivery_charge,
            'grand_total' => $grand_total,
        );
    }


    public function payWithPaypal(Request $request){

        if(env('APP_MODE') == 0){
            $notification = trans('user_validation.This Is Demo Version. You Can Not Change Anything');
            $notification=array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $user = Auth::guard('web')->user();
        $cart_contents = Cart::content();

        $calculate_amount = $this->calculate_amount(7);
        Session::put('calculate_amount', $calculate_amount);

        $paypalSetting = PaypalPayment::first();
        $payableAmount = round($calculate_amount['grand_total'] * $paypalSetting->currency_rate,2);

        $currency_code = $paypalSetting->currency_code;

        $after_success_url = route('paypal-payment-success');
        $after_faild_url = route('paypal-payment-cancled');

        $user = Auth::guard( 'web' )->user();

        $paypal_credentials = (object) [
            'paypal_client_id'    => $paypalSetting->client_id,
            'paypal_secret_key'   => $paypalSetting->secret_id,
            'paypal_account_mode' => $paypalSetting->account_mode,
        ];

        return $this->pay_with_paypal( $paypal_credentials, $payableAmount, $currency_code, $after_success_url, $after_faild_url, $user );
    }

    public function pay_with_paypal( $paypal_credentials, $payable_amount, $currency_code, $after_success_url, $after_faild_url, $user ) {

        config( ['paypal.mode' => $paypal_credentials->paypal_account_mode] );

        if ( $paypal_credentials->paypal_account_mode == 'sandbox' ) {
            config( ['paypal.sandbox.client_id' => $paypal_credentials->paypal_client_id] );
            config( ['paypal.sandbox.client_secret' => $paypal_credentials->paypal_secret_key] );
        } else {
            config( ['paypal.live.client_id' => $paypal_credentials->paypal_client_id] );
            config( ['paypal.live.client_secret' => $paypal_credentials->paypal_secret_key] );
            config( ['paypal.live.app_id' => 'APP-80W284485P519543T'] );
        }

        try {
            $provider = new PayPalClient;
            $provider->setApiCredentials( config( 'paypal' ) );
            $paypalToken = $provider->getAccessToken();
            $response = $provider->createOrder( [
                'intent'              => 'CAPTURE',
                'application_context' => [
                    'return_url' => $after_success_url,
                    'cancel_url' => $after_faild_url,
                ],
                'purchase_units'      => [
                    0 => [
                        'amount' => [
                            'currency_code' => $currency_code,
                            'value'         => $payable_amount,
                        ],
                    ],
                ],
            ] );
        } catch ( Exception $ex ) {
            $notification = 'Payment Faild';
            $notification = ['messege' => $notification, 'alert-type' => 'error'];

            return redirect()->back()->with( $notification );
        }

        if ( isset( $response['id'] ) && $response['id'] != null ) {

            Session::put( 'after_success_url', $after_success_url );
            Session::put( 'after_faild_url', $after_faild_url );
            Session::put( 'payable_amount', $payable_amount );
            Session::put( 'paypal_credentials', $paypal_credentials );

            // redirect to approve href
            foreach ( $response['links'] as $links ) {
                if ( $links['rel'] == 'approve' ) {
                    return redirect()->away( $links['href'] );
                }
            }

            $notification = trans( 'user_validation.Payment Faild' );
            $notification = ['messege' => $notification, 'alert-type' => 'error'];

            return redirect()->back()->with( $notification );

        } else {
            $notification = trans( 'user_validation.Payment Faild' );
            $notification = ['messege' => $notification, 'alert-type' => 'error'];

            return redirect()->back()->with( $notification );
        }

    }

    public function paypalPaymentSuccess( Request $request ) {

        if (empty($request->get('PayerID')) || empty($request->get('token'))) {
            $notification = trans('user_validation.Payment Faild');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->route('payment')->with($notification);
        }

        $paypal_credentials = Session::get( 'paypal_credentials' );

        config( ['paypal.mode' => $paypal_credentials->paypal_account_mode] );

        if ( $paypal_credentials->paypal_account_mode == 'sandbox' ) {
            config( ['paypal.sandbox.client_id' => $paypal_credentials->paypal_client_id] );
            config( ['paypal.sandbox.client_secret' => $paypal_credentials->paypal_secret_key] );
        } else {
            config( ['paypal.sandbox.client_id' => $paypal_credentials->paypal_client_id] );
            config( ['paypal.sandbox.client_secret' => $paypal_credentials->paypal_secret_key] );
            config( ['paypal.sandbox.app_id' => 'APP-80W284485P519543T'] );
        }

        $provider = new PayPalClient;
        $provider->setApiCredentials( config( 'paypal' ) );
        $provider->getAccessToken();
        $response = $provider->capturePaymentOrder( $request['token'] );
        if ( isset( $response['status'] ) && $response['status'] == 'COMPLETED' ) {

            Session::put( 'after_success_gateway', 'Paypal' );
            Session::put( 'after_success_transaction', $request->PayerID );


            $payment_id=$response['id'];
            $user = Auth::guard('web')->user();
            $calculate_amount = Session::get('calculate_amount');

            $order_result = $this->orderStore($user, $calculate_amount,  'Paypal', $payment_id, 1, 0, 7);

            $this->sendOrderSuccessMail($user, $order_result, 'Paypal', 1);

            $notification = trans('user_validation.Order submited successfully. please wait for admin approval');
            $notification = array('messege'=>$notification,'alert-type'=>'success');
            return redirect()->route('dashboard')->with($notification);

        } else {
            $after_faild_url = Session::get( 'after_faild_url' );
            return redirect( $after_faild_url );
        }

    }

    public function paypalPaymentCancled(){
        $notification = trans('user_validation.Payment Faild');
        $notification = array('messege'=>$notification,'alert-type'=>'error');
        return redirect()->route('payment')->with($notification);
    }

    public function orderStore($user, $calculate_amount, $payment_method, $transaction_id, $payment_status, $cash_on_delivery, $address_id){

        $order = new Order();
        $order->order_id = substr(rand(0,time()),0,10);
        $order->user_id = $user->id;
        $order->grand_total = $calculate_amount['grand_total'];
        $order->delivery_charge = $calculate_amount['delivery_charge'];
        $order->coupon_price = $calculate_amount['coupon_price'];
        $order->sub_total = $calculate_amount['sub_total'];
        $order->product_qty = Cart::count();
        $order->payment_method = $payment_method;
        $order->transection_id = $transaction_id;
        $order->payment_status = $payment_status;
        $order->order_status = 0;
        $order->cash_on_delivery = $cash_on_delivery;
        $order->save();

        $cart_contents = Cart::content();
        foreach ($cart_contents as $index => $cart_content){
            $optional_item_arr = array();
            foreach($cart_content->options->optional_items as $index => $optional_item){
                $new_item = array(
                    'item' => $optional_item['optional_name'],
                    'price' => $optional_item['optional_price'],
                );
                $optional_item_arr[] = $new_item;
            }

            $orderProduct = new OrderProduct();
            $orderProduct->order_id = $order->id;
            $orderProduct->product_id = $cart_content->id;
            $orderProduct->product_name = $cart_content->name;
            $orderProduct->unit_price = $cart_content->price;
            $orderProduct->qty = $cart_content->qty;
            $orderProduct->product_size = $cart_content->options->size;
            $orderProduct->optional_price = $cart_content->options->optional_item_price;
            $orderProduct->optional_item = json_encode($optional_item_arr);
            $orderProduct->save();
        }

        // store address
        $address_id = Session::get('delivery_id');
        $find_address = Address::find($address_id);
        $find_delivery_address = DeliveryArea::find($find_address->delivery_area_id);
        $orderAddress = new OrderAddress();
        $orderAddress->order_id = $order->id;
        $orderAddress->name = $find_address->first_name.' '.$find_address->last_name;
        $orderAddress->email = $find_address->email;
        $orderAddress->phone = $find_address->phone;
        $orderAddress->address = $find_address->address;
        $orderAddress->longitude = $find_address->longitude;
        $orderAddress->latitude = $find_address->latitude;
        $orderAddress->delivery_time = $find_delivery_address->min_time.' - '. $find_delivery_address->max_time;
        $orderAddress->save();

        Session::forget('delivery_id');
        Session::forget('delivery_charge');
        Session::forget('coupon_price');
        Session::forget('offer_type');
        Session::forget('coupon_price');
        Session::forget('offer_type');
        Cart::destroy();

        return $order;
    }


    public function sendOrderSuccessMail($user, $order_result, $payment_method, $payment_status){

        $setting = Setting::first();

        MailHelper::setMailConfig();

        $template=EmailTemplate::where('id',6)->first();

        $payment_status = $payment_status == 1 ? 'Success' : 'Pending';
        $subject=$template->subject;
        $message=$template->description;
        $message = str_replace('{{user_name}}',$user->name,$message);
        $message = str_replace('{{total_amount}}',$setting->currency_icon.$order_result->grand_total,$message);
        $message = str_replace('{{payment_method}}',$payment_method,$message);
        $message = str_replace('{{payment_status}}',$payment_status,$message);
        $message = str_replace('{{order_status}}','Pending',$message);
        $message = str_replace('{{order_date}}',$order_result->created_at->format('d F, Y'),$message);
        Mail::to($user->email)->send(new OrderSuccessfully($message,$subject));
    }
}
