<?php

namespace App\Http\Controllers\WEB\Admin;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use App\Models\SliderTranslation;
use Illuminate\Http\Request;

class SliderTranslationController extends Controller
{
    public function __construct()
    {
        $this->middleware("auth:admin");
    }

    public function create($code, $id)
    {
        $slider = Slider::findOrFail($id);

        $data = [];
        $data['language'] = $code;
        $data['slider_id'] = $slider->id;
        $data['slider'] = SliderTranslation::firstOrCreate($data);

        if (strtolower($code) === strtolower('en')) {
            $data['title_one'] = $slider->title_one;
            $data['title_two'] = $slider->title_two;
            $data['description'] = $slider->description;
            $data['offer_text'] = $slider->offer_text;
            $data['slider']->update($data);

            $notification = trans("admin_validation.Updated Successfully");

            $notification = ["messege" => $notification, "alert-type" => "success"];

            return redirect()->route('admin.slider.index')->with($notification);
        }

        return view('admin.edit_slider_translation', $data);
    }

    public function update(Request $request, $code, $id)
    {
        if (strtolower($code) === strtolower('en')) {
            $notification = trans("admin_validation.Updated Successfully");
            $notification = ["messege" => $notification, "alert-type" => "success"];
            return redirect()->route('admin.slider.index')->with($notification);
        }

        $rules = [
            'description' => 'required',
            'title_one' => 'required',
            'title_two' => 'required',
            'offer_text' => 'required',
        ];

        $customMessages = [
            'title_one.required' => trans('admin_validation.Title one is required'),
            'title_two.required' => trans('admin_validation.Title two is required'),
            'description.required' => trans('admin_validation.Description is required'),
            'offer_text.required' => trans('admin_validation.Offer text is required'),
        ];

        $validatedData = $this->validate($request, $rules, $customMessages);

        $serviceTranslation = SliderTranslation::firstOrCreate([
            'language' => $code,
            'slider_id' => $id,
        ]);

        if ($serviceTranslation->update($validatedData)) {
            $notification = trans("admin_validation.Updated Successfully");

            $notification = ["messege" => $notification, "alert-type" => "success"];
        } else {
            $notification = trans("admin_validation.Updating Failed");

            $notification = ["messege" => $notification, "alert-type" => "error"];
        }

        return redirect()->back()->with($notification);
    }
}
