<?php

namespace App\Http\Controllers\WEB\Admin;

use Auth;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;

class LanguageController extends Controller
{

    public function adminLnagugae($code)
    {
        $parentDir = dirname(app_path());

        $data = include($parentDir . "/lang/{$code}/admin.php");

        return view('admin.admin_language', compact('data'));
    }

    public function updateAdminLanguage(Request $request, $code)
    {
        $parentDir = dirname(app_path());
        $dataArray = [];
        foreach ($request->values as $index => $value) {
            $dataArray[$index] = $value;
        }

        file_put_contents($parentDir . "/lang/{$code}/admin.php", "");
        $dataArray = var_export($dataArray, true);
        file_put_contents($parentDir . "/lang/{$code}/admin.php", "<?php\n return {$dataArray};\n ?>");

        $notification = trans('admin_validation.Update Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->back()->with($notification);
    }

    public function adminValidationLnagugae($code)
    {
        $parentDir = dirname(app_path());
        $data = include($parentDir . "/lang/{$code}/admin_validation.php");

        return view('admin.admin_validation_language', compact('data'));
    }

    public function updateAdminValidationLnagugae(Request $request, $code)
    {
        $parentDir = dirname(app_path());
        $dataArray = [];
        foreach ($request->values as $index => $value) {
            $dataArray[$index] = $value;
        }
        file_put_contents($parentDir . "/lang/{$code}/admin_validation.php", "");
        $dataArray = var_export($dataArray, true);
        file_put_contents($parentDir . "/lang/{$code}/admin_validation.php", "<?php\n return {$dataArray};\n ?>");

        $notification = trans('admin_validation.Update Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->back()->with($notification);
    }

    public function websiteLanguage($code)
    {
        $parentDir = dirname(app_path());
        $data = include($parentDir . "/lang/{$code}/user.php");

        return view('admin.language', compact('data'));
    }

    public function updateLanguage(Request $request, $code)
    {
        $parentDir = dirname(app_path());
        $dataArray = [];
        foreach ($request->values as $index => $value) {
            $dataArray[$index] = $value;
        }
        file_put_contents($parentDir . "/lang/{$code}/user.php", "");
        $dataArray = var_export($dataArray, true);
        file_put_contents($parentDir . "/lang/{$code}/user.php", "<?php\n return {$dataArray};\n ?>");

        $notification = trans('admin_validation.Update Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->back()->with($notification);
    }


    public function websiteValidationLanguage($code)
    {
        $parentDir = dirname(app_path());
        $data = include($parentDir . "/lang/{$code}/user_validation.php");

        return view('admin.website_validation_language', compact('data'));
    }

    public function updateValidationLanguage(Request $request, $code)
    {
        $parentDir = dirname(app_path());
        $dataArray = [];
        foreach ($request->values as $index => $value) {
            $dataArray[$index] = $value;
        }

        file_put_contents($parentDir . "/lang/{$code}/user_validation.php", "");
        $dataArray = var_export($dataArray, true);
        file_put_contents($parentDir . "/lang/{$code}/user_validation.php", "<?php\n return {$dataArray};\n ?>");

        $notification = trans('admin_validation.Update Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->back()->with($notification);
    }

    public function updateStatus( Language $language ): JsonResponse {
        try {
            DB::beginTransaction();
            if ( $language->status == 0 ) {
                Language::where( 'status', 1 )->update( ['status' => '0'] );
            }

            if (Language::where('status', 1)->whereNot('id',$language->id)->count() == 0 && $language->status == 1) {
                Language::where( 'id', 1 )->update( ['status' => 1] );
                if($language->id != 1){
                    $language->status = '0';
                }
            } else {
                $language->status = $language->status ? '0' : 1;
            }

            $action = $language->save();

            // Set session and cache for the default language
            $default_lang_info = Language::where( 'status', 1 )->first();
            if ( $default_lang_info ) {
                session( ['lang' => $default_lang_info->code] );
                session( ['text_direction' => $default_lang_info->direction] );
                Cache::put( 'default_lang', $default_lang_info->code );
            }

            DB::commit();
            return response()->json( [
                'status'  => $action,
                'message' => $action ? trans( 'admin_validation.Updated Successfully' ) : trans( 'admin_validation.Updating Failed' ),
            ] );

        } catch ( \Exception $e ) {
            DB::rollBack();
            return response()->json( [
                'status'  => false,
                'message' => trans( 'admin_validation.Updating Failed' ),
            ] );
        }
    }
}
